/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import com.google.common.base.Preconditions;
import java.awt.Graphics2D;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nodebox.graphics.MathUtils;

public final class Color
implements Cloneable {
    private static final Pattern HEX_STRING_PATTERN = Pattern.compile("^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$");
    public static final Color BLACK = new Color(0.0);
    public static final Color WHITE = new Color(1.0);
    private final double r;
    private final double g;
    private final double b;
    private final double a;
    private final double h;
    private final double s;
    private final double v;
    private transient java.awt.Color awtColor = null;

    public static Color fromHSB(double hue, double saturation, double brightness) {
        return new Color(hue, saturation, brightness, Mode.HSB);
    }

    public static Color fromHSB(double hue, double saturation, double brightness, double alpha) {
        return new Color(hue, saturation, brightness, alpha, Mode.HSB);
    }

    public static Color valueOf(String hex) {
        return new Color(hex);
    }

    public Color() {
        this(0.0, 0.0, 0.0, 1.0, Mode.RGB);
    }

    public Color(double v) {
        this(v, v, v, 1.0, Mode.RGB);
    }

    public Color(double v, double a) {
        this(v, v, v, a, Mode.RGB);
    }

    public Color(double x, double y, double z, Mode m) {
        this(x, y, z, 1.0, m);
    }

    public Color(double r, double g, double b) {
        this(r, g, b, 1.0, Mode.RGB);
    }

    public Color(double r, double g, double b, double a) {
        this(r, g, b, a, Mode.RGB);
    }

    public Color(double x, double y, double z, double a, Mode m) {
        Preconditions.checkArgument((m != Mode.CMYK ? 1 : 0) != 0, (Object)"CMYK not supported");
        switch (m) {
            case CMYK: {
                throw new RuntimeException("CMYK color mode is not implemented yet.");
            }
            case HSB: {
                this.h = MathUtils.clamp(x);
                this.s = MathUtils.clamp(y);
                this.v = MathUtils.clamp(z);
                this.a = MathUtils.clamp(a);
                double[] rgb = this.updateRGB();
                this.r = rgb[0];
                this.g = rgb[1];
                this.b = rgb[2];
                break;
            }
            default: {
                this.r = MathUtils.clamp(x);
                this.g = MathUtils.clamp(y);
                this.b = MathUtils.clamp(z);
                this.a = MathUtils.clamp(a);
                double[] hsb = this.updateHSB();
                this.h = hsb[0];
                this.s = hsb[1];
                this.v = hsb[2];
            }
        }
    }

    public Color(String colorName) {
        Matcher m = HEX_STRING_PATTERN.matcher(colorName);
        if (!m.matches()) {
            throw new IllegalArgumentException("The given value '" + colorName + "' is not of the format #112233ff.");
        }
        int r255 = Integer.parseInt(m.group(1), 16);
        int g255 = Integer.parseInt(m.group(2), 16);
        int b255 = Integer.parseInt(m.group(3), 16);
        int a255 = Integer.parseInt(m.group(4), 16);
        this.r = (double)r255 / 255.0;
        this.g = (double)g255 / 255.0;
        this.b = (double)b255 / 255.0;
        this.a = (double)a255 / 255.0;
        double[] hsb = this.updateHSB();
        this.h = hsb[0];
        this.s = hsb[1];
        this.v = hsb[2];
    }

    public Color(java.awt.Color color) {
        this((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0, (double)color.getAlpha() / 255.0);
    }

    public Color(Color other) {
        this(other.r, other.g, other.b, other.a);
    }

    public double getRed() {
        return this.r;
    }

    public double getR() {
        return this.r;
    }

    public double getGreen() {
        return this.g;
    }

    public double getG() {
        return this.g;
    }

    public double getBlue() {
        return this.b;
    }

    public double getB() {
        return this.b;
    }

    public double getAlpha() {
        return this.a;
    }

    public double getA() {
        return this.a;
    }

    public boolean isVisible() {
        return this.a > 0.0;
    }

    public double getHue() {
        return this.h;
    }

    public double getH() {
        return this.h;
    }

    public double getSaturation() {
        return this.s;
    }

    public double getS() {
        return this.s;
    }

    public double getBrightness() {
        return this.v;
    }

    public double getV() {
        return this.v;
    }

    private double[] updateRGB() {
        if (this.s == 0.0) {
            return new double[]{this.v, this.v, this.v};
        }
        double h = this.h;
        if (this.h == 1.0) {
            h = 0.999998;
        }
        double s = this.s;
        double v = this.v;
        int i = (int)Math.floor(h /= 0.16666666666666666);
        double f = h - (double)i;
        double p = v * (1.0 - s);
        double q = v * (1.0 - s * f);
        double t = v * (1.0 - s * (1.0 - f));
        double[] rgb = i == 0 ? new double[]{v, t, p} : (i == 1 ? new double[]{q, v, p} : (i == 2 ? new double[]{p, v, t} : (i == 3 ? new double[]{p, q, v} : (i == 4 ? new double[]{t, p, v} : new double[]{v, p, q}))));
        return new double[]{rgb[0], rgb[1], rgb[2]};
    }

    private double[] updateHSB() {
        double h = 0.0;
        double s = 0.0;
        double v = Math.max(Math.max(this.r, this.g), this.b);
        double d = v - Math.min(Math.min(this.r, this.g), this.b);
        if (v != 0.0) {
            s = d / v;
        }
        if (s != 0.0) {
            h = this.r == v ? 0.0 + (this.g - this.b) / d : (this.g == v ? 2.0 + (this.b - this.r) / d : 4.0 + (this.r - this.g) / d);
        }
        if ((h *= 0.16666666666666666) < 0.0) {
            h += 1.0;
        }
        return new double[]{h, s, v};
    }

    private void updateCMYK() {
    }

    public java.awt.Color getAwtColor() {
        return new java.awt.Color((float)this.getRed(), (float)this.getGreen(), (float)this.getBlue(), (float)this.getAlpha());
    }

    public void set(Graphics2D g) {
        if (this.awtColor == null) {
            this.awtColor = new java.awt.Color((float)this.getRed(), (float)this.getGreen(), (float)this.getBlue(), (float)this.getAlpha());
        }
        g.setColor(this.awtColor);
    }

    public Color clone() {
        return new Color(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Color)) {
            return false;
        }
        Color other = (Color)obj;
        return Math.round(this.r * 255.0) == Math.round(other.r * 255.0) && Math.round(this.g * 255.0) == Math.round(other.g * 255.0) && Math.round(this.b * 255.0) == Math.round(other.b * 255.0) && Math.round(this.a * 255.0) == Math.round(other.a * 255.0);
    }

    public static Color parseColor(String value) {
        return new Color(value);
    }

    private String paddedHexString(int v) {
        String s = Integer.toHexString(v);
        if (s.length() == 1) {
            return "0" + s;
        }
        if (s.length() == 2) {
            return s;
        }
        throw new AssertionError((Object)("Value too large (must be between 0-255, was " + v + ")."));
    }

    public String toString() {
        int r256 = (int)Math.round(this.r * 255.0);
        int g256 = (int)Math.round(this.g * 255.0);
        int b256 = (int)Math.round(this.b * 255.0);
        int a256 = (int)Math.round(this.a * 255.0);
        return "#" + this.paddedHexString(r256) + this.paddedHexString(g256) + this.paddedHexString(b256) + this.paddedHexString(a256);
    }

    public static enum Mode {
        RGB,
        HSB,
        CMYK;

    }
}

