/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import nodebox.graphics.GraphicsContext;
import nodebox.graphics.Grob;
import nodebox.graphics.Rect;
import nodebox.graphics.Transform;
import nodebox.graphics.TransformDelegate;

public class ContextTransformDelegate
implements TransformDelegate {
    private GraphicsContext context;
    private Transform transform;
    private Transform currentTransform;

    public ContextTransformDelegate(GraphicsContext context) {
        this.context = context;
        this.transform = new Transform();
        this.currentTransform = new Transform();
    }

    @Override
    public void transform(Grob g, Transform t) {
        this.transform(g, t, false);
    }

    @Override
    public void transform(Grob g, Transform t, boolean override) {
        if (override) {
            this.currentTransform = new Transform();
        }
        if (!this.transform.getAffineTransform().isIdentity()) {
            Transform revertedTransform = this.transform.clone();
            revertedTransform.invert();
            g.transform(revertedTransform);
        }
        this.currentTransform.append(t);
        Rect bounds = g.getBounds();
        double dx = bounds.getX() + bounds.getWidth() / 2.0;
        double dy = bounds.getY() + bounds.getHeight() / 2.0;
        this.transform = this.currentTransform.clone();
        if (this.context.transform() == Transform.Mode.CENTER) {
            Transform n = new Transform();
            n.translate(dx, dy);
            this.transform.prepend(n);
            n = new Transform();
            n.translate(-dx, -dy);
            this.transform.append(n);
        }
        g.transform(this.transform);
    }
}

