/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import com.google.common.base.Function;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import nodebox.graphics.AbstractGeometry;
import nodebox.graphics.IGeometry;
import nodebox.graphics.NodeBoxError;
import nodebox.graphics.Path;
import nodebox.graphics.Point;
import nodebox.graphics.Rect;
import nodebox.graphics.Transform;

public class Contour
extends AbstractGeometry {
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final int SEGMENT_ACCURACY = 20;
    private List<Point> points;
    private boolean closed;
    private transient ArrayList<Double> segmentLengths;
    private transient double length = -1.0;

    public Contour() {
        this.points = new ArrayList<Point>();
        this.closed = false;
    }

    public Contour(Contour other) {
        this.points = new ArrayList<Point>(other.points.size());
        for (Point p : other.points) {
            this.points.add(p);
        }
        this.closed = other.closed;
    }

    public Contour(Iterable<Point> points, boolean closed) {
        this.points = new ArrayList<Point>();
        for (Point p : points) {
            this.points.add(p);
        }
        this.closed = closed;
    }

    @Override
    public int getPointCount() {
        return this.points.size();
    }

    @Override
    public List<Point> getPoints() {
        return this.points;
    }

    void setPoints(List<Point> points) {
        this.points = points;
    }

    @Override
    public void addPoint(Point pt) {
        this.points.add(pt);
        this.invalidate();
    }

    @Override
    public void addPoint(double x, double y) {
        this.points.add(new Point(x, y));
        this.invalidate();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
        this.invalidate();
    }

    public void close() {
        this.closed = true;
        this.invalidate();
    }

    @Override
    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    @Override
    public Rect getBounds() {
        if (this.points.isEmpty()) {
            return new Rect();
        }
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Point p : this.points) {
            double px = p.getX();
            double py = p.getY();
            if (px < minX) {
                minX = px;
            }
            if (py < minY) {
                minY = py;
            }
            if (px > maxX) {
                maxX = px;
            }
            if (!(py > maxY)) continue;
            maxY = py;
        }
        return new Rect(minX, minY, maxX - minX, maxY - minY);
    }

    public void invalidate() {
        this.segmentLengths = null;
    }

    public double updateSegmentLengths() {
        List<Point> points = this.getPoints();
        this.segmentLengths = new ArrayList();
        double totalLength = 0.0;
        for (int pi = 1; pi < points.size(); ++pi) {
            Point pt0;
            Point pt = points.get(pi);
            if (pt.isLineTo()) {
                pt0 = points.get(pi - 1);
                double length = Path.lineLength(pt0.x, pt0.y, pt.x, pt.y);
                this.segmentLengths.add(length);
                totalLength += length;
                continue;
            }
            if (!pt.isCurveTo()) continue;
            pt0 = points.get(pi - 3);
            Point c1 = points.get(pi - 2);
            Point c2 = points.get(pi - 1);
            double length = Path.curveLength(pt0.x, pt0.y, c1.x, c1.y, c2.x, c2.y, pt.x, pt.y, 20);
            this.segmentLengths.add(length);
            totalLength += length;
        }
        if (this.closed && !points.isEmpty()) {
            Point pt0 = points.get(points.size() - 1);
            Point pt1 = points.get(0);
            double length = Path.lineLength(pt0.x, pt0.y, pt1.x, pt1.y);
            this.segmentLengths.add(length);
            totalLength += length;
        }
        this.length = totalLength;
        return totalLength;
    }

    public double getLength() {
        if (this.segmentLengths == null) {
            this.updateSegmentLengths();
        }
        assert (this.length != -1.0);
        return this.length;
    }

    @Override
    public Point pointAt(double t) {
        if (this.segmentLengths == null) {
            this.updateSegmentLengths();
        }
        if (this.points.isEmpty()) {
            throw new NodeBoxError("The path is empty.");
        }
        if (this.length == 0.0) {
            return this.points.get(0);
        }
        double absT = t * this.length;
        double resT = t;
        int segnum = -1;
        for (Double seglength : this.segmentLengths) {
            if (absT <= seglength || ++segnum == this.segmentLengths.size() - 1) break;
            absT -= seglength.doubleValue();
            resT -= seglength / this.length;
        }
        resT /= this.segmentLengths.get(segnum) / this.length;
        int pi = this.pointIndexForSegment(segnum + 1);
        Point pt1 = this.points.get(pi);
        if (pi == 0) {
            pi = this.points.size();
        }
        if (pt1.isLineTo()) {
            Point pt0 = this.points.get(pi - 1);
            return Path.linePoint(resT, pt0.x, pt0.y, pt1.x, pt1.y);
        }
        if (pt1.isCurveTo()) {
            Point pt0 = this.points.get(pi - 3);
            Point c1 = this.points.get(pi - 2);
            Point c2 = this.points.get(pi - 1);
            return Path.curvePoint(resT, pt0.x, pt0.y, c1.x, c1.y, c2.x, c2.y, pt1.x, pt1.y);
        }
        throw new AssertionError((Object)"Incorrect point.");
    }

    public Point point(double t) {
        return this.pointAt(t);
    }

    private int pointIndexForSegment(int segnum) {
        int pointCount;
        int pointIndex = 0;
        for (Point pt : this.points) {
            if (pt.isCurveTo() || pt.isLineTo()) {
                if (segnum == 0) break;
                --segnum;
            }
            ++pointIndex;
        }
        if (pointIndex < (pointCount = this.points.size())) {
            return pointIndex;
        }
        if (this.closed) {
            return 0;
        }
        return pointCount - 1;
    }

    @Override
    public Point[] makePoints(int amount) {
        if (this.points.isEmpty()) {
            return new Point[0];
        }
        Point[] points = new Point[amount];
        double delta = 1.0;
        if (this.closed) {
            if (amount > 0) {
                delta = 1.0 / (double)amount;
            }
        } else if (amount > 2) {
            delta = 1.0 / ((double)amount - 1.0);
        }
        for (int i = 0; i < amount; ++i) {
            points[i] = this.pointAt(delta * (double)i);
        }
        return points;
    }

    @Override
    public Point[] makePoints(int amount, boolean perContour) {
        return this.makePoints(amount);
    }

    @Override
    public Contour resampleByAmount(int amount, boolean perContour) {
        return this.resampleByAmount(amount);
    }

    public Contour resampleByAmount(int amount) {
        Contour c = new Contour();
        c.extend(this.makePoints(amount));
        c.setClosed(this.closed);
        return c;
    }

    @Override
    public Contour resampleByLength(double segmentLength) {
        if (segmentLength <= 1.0E-7) {
            throw new IllegalArgumentException("Segment length must be greater than zero.");
        }
        double contourLength = this.getLength();
        int amount = (int)Math.ceil(contourLength / segmentLength);
        if (this.closed) {
            return this.resampleByAmount(amount);
        }
        return this.resampleByAmount(amount + 1);
    }

    @Override
    public void flatten() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IGeometry flattened() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.getPointCount() < 2) {
            return;
        }
        Color savedColor = g.getColor();
        Stroke savedStroke = g.getStroke();
        GeneralPath gp = new GeneralPath(0, this.getPointCount());
        this._extendPath(gp);
        g.setColor(Color.BLACK);
        g.setStroke(DEFAULT_STROKE);
        g.draw(gp);
        g.setColor(savedColor);
        g.setStroke(savedStroke);
    }

    void _extendPath(GeneralPath gp) {
        if (this.points.size() == 0) {
            return;
        }
        Point pt = this.points.get(0);
        gp.moveTo(pt.x, pt.y);
        int pointCount = this.getPointCount();
        for (int i = 1; i < pointCount; ++i) {
            pt = this.points.get(i);
            if (pt.isLineTo()) {
                gp.lineTo(pt.x, pt.y);
                continue;
            }
            if (!pt.isCurveTo()) continue;
            Point ctrl1 = this.points.get(i - 2);
            Point ctrl2 = this.points.get(i - 1);
            gp.curveTo(ctrl1.x, ctrl1.y, ctrl2.x, ctrl2.y, pt.x, pt.y);
        }
        if (this.closed) {
            gp.closePath();
        }
    }

    @Override
    public void transform(Transform t) {
        this.points = t.map(this.getPoints());
        this.invalidate();
    }

    public Path toPath() {
        return new Path(this);
    }

    @Override
    public AbstractGeometry mapPoints(Function<Point, Point> pointFunction) {
        Contour c = new Contour();
        c.setClosed(this.isClosed());
        for (Point point : this.getPoints()) {
            Point newPoint = (Point)pointFunction.apply((Object)point);
            c.addPoint(newPoint);
        }
        return c;
    }

    @Override
    public Contour clone() {
        return new Contour(this);
    }
}

