/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import com.google.common.base.Function;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import nodebox.graphics.AbstractGeometry;
import nodebox.graphics.Color;
import nodebox.graphics.Colorizable;
import nodebox.graphics.Contour;
import nodebox.graphics.IGeometry;
import nodebox.graphics.Path;
import nodebox.graphics.Point;
import nodebox.graphics.Rect;
import nodebox.graphics.Transform;

public class Geometry
extends AbstractGeometry
implements Colorizable {
    private ArrayList<Path> paths;
    private Path currentPath;
    private boolean lengthDirty = true;
    private ArrayList<Double> pathLengths;
    private double groupLength;

    public Geometry() {
        this.paths = new ArrayList();
        this.currentPath = null;
    }

    public Geometry(Geometry other) {
        this.paths = new ArrayList(other.paths.size());
        for (Path path : other.paths) {
            this.paths.add(path.clone());
        }
        this.currentPath = null;
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    public void add(Path path) {
        this.paths.add(path);
        this.currentPath = path;
        this.invalidate(false);
    }

    public void add(Geometry geometry) {
        this.extend(geometry);
    }

    public int size() {
        return this.paths.size();
    }

    @Override
    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    public void clear() {
        this.paths.clear();
        this.currentPath = null;
        this.invalidate(false);
    }

    public void extend(Geometry g) {
        for (Path path : g.paths) {
            this.paths.add(path.clone());
        }
        this.invalidate(false);
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        Path lastPath = this.paths.get(this.paths.size() - 1);
        return lastPath.isClosed();
    }

    @Override
    public void setFillColor(Color fillColor) {
        for (Path path : this.paths) {
            path.setFillColor(fillColor);
        }
    }

    @Override
    public void setFill(Color c) {
        this.setFillColor(c);
    }

    @Override
    public void setStrokeColor(Color strokeColor) {
        for (Path path : this.paths) {
            path.setStrokeColor(strokeColor);
        }
    }

    @Override
    public void setStroke(Color c) {
        this.setStrokeColor(c);
    }

    @Override
    public void setStrokeWidth(double strokeWidth) {
        for (Path path : this.paths) {
            path.setStrokeWidth(strokeWidth);
        }
    }

    @Override
    public int getPointCount() {
        int pointCount = 0;
        for (Path path : this.paths) {
            pointCount += path.getPointCount();
        }
        return pointCount;
    }

    @Override
    public List<Point> getPoints() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (Path path : this.paths) {
            points.addAll(path.getPoints());
        }
        return points;
    }

    @Override
    public void addPoint(Point pt) {
        this.ensureCurrentPath();
        this.currentPath.addPoint(pt);
        this.invalidate(false);
    }

    @Override
    public void addPoint(double x, double y) {
        this.ensureCurrentPath();
        this.currentPath.addPoint(x, y);
        this.invalidate(false);
    }

    private void ensureCurrentPath() {
        if (this.currentPath != null) {
            return;
        }
        this.currentPath = new Path();
        this.add(this.currentPath);
    }

    public void invalidate() {
        this.invalidate(true);
    }

    private void invalidate(boolean recursive) {
        this.lengthDirty = true;
        if (recursive) {
            for (Path path : this.paths) {
                path.invalidate();
            }
        }
    }

    @Override
    public Rect getBounds() {
        if (this.isEmpty()) {
            return new Rect();
        }
        Rect r = null;
        for (Path g : this.paths) {
            if (r == null) {
                r = g.getBounds();
            }
            if (g.isEmpty()) continue;
            r = r.united(g.getBounds());
        }
        return r != null ? r : new Rect();
    }

    public double getLength() {
        if (this.lengthDirty) {
            this.updatePathLengths();
        }
        return this.groupLength;
    }

    private void updatePathLengths() {
        this.pathLengths = new ArrayList(this.paths.size());
        this.groupLength = 0.0;
        for (Path p : this.paths) {
            double length = p.getLength();
            this.pathLengths.add(length);
            this.groupLength += length;
        }
        this.lengthDirty = false;
    }

    @Override
    public Point pointAt(double t) {
        double length = this.getLength();
        double absT = t * length;
        double resT = t;
        Path currentPath = null;
        Iterator<Path> i$ = this.paths.iterator();
        while (i$.hasNext()) {
            Path p;
            currentPath = p = i$.next();
            double cLength = p.getLength();
            if (absT <= cLength) break;
            absT -= cLength;
            resT -= cLength / length;
        }
        if (currentPath == null) {
            return Point.ZERO;
        }
        return currentPath.pointAt(resT /= currentPath.getLength() / length);
    }

    public boolean contains(Point pt) {
        for (Path p : this.paths) {
            if (!p.contains(pt)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(double x, double y) {
        for (Path p : this.paths) {
            if (!p.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Rect r) {
        for (Path p : this.paths) {
            if (!p.contains(r)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Geometry g2) {
        for (Path p1 : this.getPaths()) {
            for (Path p2 : g2.getPaths()) {
                if (!p1.intersects(p2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersects(Path p) {
        for (Path p1 : this.getPaths()) {
            if (!p1.intersects(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Point[] makePoints(int amount, boolean perContour) {
        if (perContour) {
            ArrayList<Point> points = new ArrayList<Point>();
            for (Path p : this.getPaths()) {
                for (Contour c : p.getContours()) {
                    Point[] pointsFromContour = c.makePoints(amount);
                    points.addAll(Arrays.asList(pointsFromContour));
                }
            }
            return (Point[])points.toArray();
        }
        double delta = this.pointDelta(amount, this.isClosed());
        Point[] points = new Point[amount];
        for (int i = 0; i < amount; ++i) {
            points[i] = this.pointAt(delta * (double)i);
        }
        return points;
    }

    @Override
    public Geometry resampleByAmount(int amount, boolean perContour) {
        if (perContour) {
            Geometry g = new Geometry();
            for (Path p : this.paths) {
                g.add(p.resampleByAmount(amount, true));
            }
            return g;
        }
        Geometry g = new Geometry();
        double delta = this.pointDelta(amount, this.isClosed());
        for (int i = 0; i < amount; ++i) {
            g.addPoint(this.pointAt(delta * (double)i));
        }
        if (this.isClosed() && g.paths.size() == 1) {
            g.paths.get(0).close();
            g.invalidate();
        }
        return g;
    }

    @Override
    public Geometry resampleByLength(double segmentLength) {
        Geometry g = new Geometry();
        for (Path p : this.paths) {
            g.add(p.resampleByLength(segmentLength));
        }
        return g;
    }

    @Override
    public void transform(Transform t) {
        for (Path path : this.paths) {
            path.transform(t);
        }
        this.invalidate(true);
    }

    @Override
    public void draw(Graphics2D g) {
        for (Path grob : this.paths) {
            grob.draw(g);
        }
    }

    @Override
    public void flatten() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IGeometry flattened() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractGeometry mapPoints(Function<Point, Point> pointFunction) {
        Geometry newGeometry = new Geometry();
        for (Path p : this.getPaths()) {
            Path newPath = (Path)p.mapPoints(pointFunction);
            newGeometry.add(newPath);
        }
        return newGeometry;
    }

    @Override
    public Geometry clone() {
        return new Geometry(this);
    }

    public String toString() {
        return "<Geometry>";
    }
}

