/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.management.RuntimeErrorException;
import nodebox.graphics.AbstractGrob;
import nodebox.graphics.MathUtils;
import nodebox.graphics.Rect;
import nodebox.graphics.Size;
import nodebox.graphics.Transform;

public class Image
extends AbstractGrob {
    private double x;
    private double y;
    private double desiredWidth;
    private double desiredHeight;
    private double alpha = 1.0;
    private BufferedImage image;
    private static BufferedImage blankImage = new BufferedImage(1, 1, 10);
    public static final String BLANK_IMAGE = "__blank";

    public Image() {
        this(new File(BLANK_IMAGE));
    }

    public Image(File file) {
        if (file == null || file.getPath().equals(BLANK_IMAGE)) {
            this.image = blankImage;
        } else {
            try {
                this.image = ImageIO.read(file);
            }
            catch (IOException e) {
                throw new RuntimeErrorException(null, "Could not read image " + file);
            }
        }
    }

    public Image(String fname) {
        this(new File(fname));
    }

    public Image(String fname, double cx, double cy) {
        this(new File(fname));
        this.x = cx;
        this.y = cy;
    }

    public Image(BufferedImage image) {
        this.image = image;
    }

    public Image(Image other) {
        super(other);
        this.x = other.x;
        this.y = other.y;
        this.desiredWidth = other.desiredWidth;
        this.desiredHeight = other.desiredHeight;
        this.alpha = other.alpha;
        this.image = other.image;
    }

    public static Image fromData(byte[] data) {
        BufferedInputStream istream = new BufferedInputStream(new ByteArrayInputStream(data));
        try {
            return new Image(ImageIO.read(istream));
        }
        catch (IOException e) {
            throw new RuntimeErrorException(null, "Could not read image data.");
        }
    }

    public double getOriginalWidth() {
        if (this.image == null) {
            return 0.0;
        }
        return this.image.getWidth();
    }

    public double getOriginalHeight() {
        if (this.image == null) {
            return 0.0;
        }
        return this.image.getHeight();
    }

    public double getWidth() {
        return this.getOriginalWidth() * this.getScaleFactor();
    }

    public void setWidth(double width) {
        this.desiredWidth = width;
    }

    public double getHeight() {
        return this.getOriginalHeight() * this.getScaleFactor();
    }

    public void setHeight(double height) {
        this.desiredHeight = height;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public BufferedImage getAwtImage() {
        return this.image;
    }

    public Size getSize() {
        return new Size(this.image.getWidth(), this.image.getHeight());
    }

    protected void setupTransform(Graphics2D g) {
        this.saveTransform(g);
        AffineTransform trans = g.getTransform();
        trans.concatenate(this.getTransform().getAffineTransform());
        g.setTransform(trans);
    }

    @Override
    public boolean isEmpty() {
        return this.image == null || this.image.getWidth() == 0 || this.image.getHeight() == 0;
    }

    @Override
    public Rect getBounds() {
        if (this.image == null) {
            return new Rect();
        }
        double factor = this.getScaleFactor();
        double finalWidth = (double)this.image.getWidth() * factor;
        double finalHeight = (double)this.image.getHeight() * factor;
        return new Rect(this.x - finalWidth / 2.0, this.y - finalHeight / 2.0, finalWidth, finalHeight);
    }

    public double getScaleFactor() {
        if (this.desiredWidth != 0.0 || this.desiredHeight != 0.0) {
            double srcW = this.image.getWidth();
            double srcH = this.image.getHeight();
            if (this.desiredWidth != 0.0 && this.desiredHeight != 0.0) {
                return Math.min(this.desiredWidth / srcW, this.desiredHeight / srcH);
            }
            if (this.desiredWidth != 0.0) {
                return this.desiredWidth / srcW;
            }
            return this.desiredHeight / srcH;
        }
        return 1.0;
    }

    @Override
    public void draw(Graphics2D g) {
        this.setupTransform(g);
        Transform imageTrans = new Transform();
        double factor = this.getScaleFactor();
        double finalWidth = (double)this.image.getWidth() * factor;
        double finalHeight = (double)this.image.getHeight() * factor;
        imageTrans.translate(this.x - finalWidth / 2.0, this.y - finalHeight / 2.0);
        imageTrans.scale(this.getScaleFactor());
        double a = MathUtils.clamp(this.alpha);
        AlphaComposite composite = AlphaComposite.getInstance(3, (float)a);
        Composite oldComposite = g.getComposite();
        g.setComposite(composite);
        g.drawRenderedImage(this.image, imageTrans.getAffineTransform());
        g.setComposite(oldComposite);
        this.restoreTransform(g);
    }

    @Override
    public Image clone() {
        return new Image(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        return this.x == other.x && this.y == other.y && this.desiredWidth == other.desiredWidth && this.desiredHeight == other.desiredHeight && this.alpha == other.alpha && this.image.equals(other.image) && super.equals(other);
    }

    public String toString() {
        return "<Image (" + this.getWidth() + ", " + this.getHeight() + ")>";
    }
}

