/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import java.util.Random;

public final class MathUtils {
    private MathUtils() {
    }

    public static float clamp(float v) {
        return 0.0f > v ? 0.0f : (1.0f < v ? 1.0f : v);
    }

    public static double clamp(double v) {
        return 0.0 > v ? 0.0 : (1.0 < v ? 1.0 : v);
    }

    public static float clamp(float v, float min, float max) {
        return min > v ? min : (max < v ? max : v);
    }

    public static double clamp(double v, double min, double max) {
        return min > v ? min : (max < v ? max : v);
    }

    public static double snap(double v, double distance, double strength) {
        return v * (1.0 - strength) + strength * (double)Math.round(v / distance) * distance;
    }

    public static Random randomFromSeed(long seed) {
        return new Random(seed * 1000000000L);
    }
}

