/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import nodebox.graphics.Drawable;
import nodebox.graphics.Rect;

public class PDFRenderer {
    private static boolean initialized = false;
    private static DefaultFontMapper fontMapper;

    public static void initialize() {
        if (initialized) {
            return;
        }
        fontMapper = new DefaultFontMapper();
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            fontMapper.insertDirectory("C:\\windows\\fonts");
        } else if (osName.startsWith("Mac OS X")) {
            fontMapper.insertDirectory("/Library/Fonts");
            String userHome = System.getProperty("user.home");
            fontMapper.insertDirectory(userHome + "/Fonts");
        }
        initialized = true;
    }

    public static void render(Drawable drawable, Rect bounds, File file) {
        PDFRenderer.render(drawable, new Rectangle2D.Double(0.0, 0.0, bounds.width, bounds.height), file);
    }

    public static void render(Drawable drawable, Rectangle2D bounds, File file) {
        PdfWriter writer;
        FileOutputStream fos;
        PDFRenderer.initialize();
        Rectangle size = new Rectangle((float)bounds.getWidth(), (float)bounds.getHeight());
        Document document = new Document(size);
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("The file " + file + "could not be created", e);
        }
        try {
            writer = PdfWriter.getInstance((Document)document, (OutputStream)fos);
        }
        catch (DocumentException e) {
            throw new RuntimeException("An error occurred while creating a PdfWriter object.", e);
        }
        document.open();
        PdfContentByte contentByte = writer.getDirectContent();
        PdfGraphics2D g = new PdfGraphics2D(contentByte, (float)bounds.getWidth(), (float)bounds.getHeight(), (FontMapper)fontMapper);
        g.translate(-bounds.getX(), -bounds.getY());
        drawable.draw((Graphics2D)g);
        g.dispose();
        document.close();
    }
}

