/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import com.google.common.base.Function;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import nodebox.graphics.AbstractGeometry;
import nodebox.graphics.Color;
import nodebox.graphics.Colorizable;
import nodebox.graphics.Contour;
import nodebox.graphics.Geometry;
import nodebox.graphics.Point;
import nodebox.graphics.Rect;
import nodebox.graphics.Text;
import nodebox.graphics.Transform;

public class Path
extends AbstractGeometry
implements Colorizable,
Iterable<Point> {
    private static final double ONE_MINUS_QUARTER = 0.44799999999999995;
    private Color fillColor = null;
    private Color strokeColor = null;
    private double strokeWidth = 1.0;
    private ArrayList<Contour> contours;
    private transient Contour currentContour = null;
    private transient boolean pathDirty = true;
    private transient boolean lengthDirty = true;
    private transient GeneralPath awtPath;
    private transient Rect bounds;
    private transient ArrayList<Double> contourLengths;
    private transient double pathLength = -1.0;

    public Path() {
        this.fillColor = Color.BLACK;
        this.strokeColor = null;
        this.strokeWidth = 1.0;
        this.contours = new ArrayList();
        this.currentContour = null;
    }

    public Path(Path other) {
        this(other, true);
    }

    public Path(Path other, boolean cloneContours) {
        this.fillColor = other.fillColor == null ? null : other.fillColor.clone();
        this.strokeColor = other.strokeColor == null ? null : other.strokeColor.clone();
        this.strokeWidth = other.strokeWidth;
        if (cloneContours) {
            this.contours = new ArrayList(other.contours.size());
            this.extend(other);
            if (!this.contours.isEmpty()) {
                this.currentContour = this.contours.get(this.contours.size() - 1);
            }
        } else {
            this.contours = new ArrayList();
            this.currentContour = null;
        }
    }

    public Path(Shape s) {
        this();
        this.extend(s);
    }

    public Path(Contour c) {
        this();
        this.add(c);
    }

    public Geometry asGeometry() {
        Geometry g = new Geometry();
        g.add(this);
        return g;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Color getFill() {
        return this.fillColor;
    }

    @Override
    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    @Override
    public void setFill(Color c) {
        this.setFillColor(c);
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public Color getStroke() {
        return this.strokeColor;
    }

    @Override
    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    @Override
    public void setStroke(Color c) {
        this.setStrokeColor(c);
    }

    public double getStrokeWidth() {
        return this.strokeWidth;
    }

    @Override
    public void setStrokeWidth(double strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    @Override
    public int getPointCount() {
        if (this.contours == null) {
            return 0;
        }
        int pointCount = 0;
        for (Contour c : this.contours) {
            pointCount += c.getPointCount();
        }
        return pointCount;
    }

    @Override
    public List<Point> getPoints() {
        if (this.contours.isEmpty()) {
            return new ArrayList<Point>(0);
        }
        ArrayList<Point> points = new ArrayList<Point>();
        for (Contour c : this.contours) {
            points.addAll(c.getPoints());
        }
        return points;
    }

    public void moveto(double x, double y) {
        this.currentContour = null;
        this.addPoint(x, y);
    }

    public void lineto(double x, double y) {
        if (this.currentContour == null) {
            throw new RuntimeException("Lineto without moveto first.");
        }
        this.addPoint(x, y);
    }

    public void curveto(double x1, double y1, double x2, double y2, double x3, double y3) {
        if (this.currentContour == null) {
            throw new RuntimeException("Curveto without moveto first.");
        }
        this.addPoint(new Point(x1, y1, 3));
        this.addPoint(new Point(x2, y2, 3));
        this.addPoint(new Point(x3, y3, 2));
    }

    public void close() {
        if (this.currentContour != null) {
            this.currentContour.close();
        }
        this.currentContour = null;
        this.invalidate(false);
    }

    public void newContour() {
        this.currentContour = null;
    }

    @Override
    public void addPoint(Point pt) {
        this.ensureCurrentContour();
        this.currentContour.addPoint(pt);
        this.invalidate(false);
    }

    @Override
    public void addPoint(double x, double y) {
        this.ensureCurrentContour();
        this.currentContour.addPoint(x, y);
        this.invalidate(false);
    }

    public void invalidate() {
        this.invalidate(true);
    }

    private void invalidate(boolean recursive) {
        this.pathDirty = true;
        this.lengthDirty = true;
        if (recursive) {
            for (Contour c : this.contours) {
                c.invalidate();
            }
        }
    }

    private void ensureCurrentContour() {
        if (this.currentContour != null) {
            return;
        }
        this.currentContour = new Contour();
        this.add(this.currentContour);
    }

    public void rect(Rect r) {
        this.rect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public void rect(double cx, double cy, double width, double height) {
        double w2 = width / 2.0;
        double h2 = height / 2.0;
        this.addPoint(cx - w2, cy - h2);
        this.addPoint(cx + w2, cy - h2);
        this.addPoint(cx + w2, cy + h2);
        this.addPoint(cx - w2, cy + h2);
        this.close();
    }

    public void rect(Rect r, double roundness) {
        this.roundedRect(r.getX(), r.getY(), r.getWidth(), r.getHeight(), roundness);
    }

    public void rect(Rect r, double rx, double ry) {
        this.roundedRect(r.getX(), r.getY(), r.getWidth(), r.getHeight(), rx, ry);
    }

    public void rect(double cx, double cy, double width, double height, double r) {
        this.roundedRect(cx, cy, width, height, r);
    }

    public void rect(double cx, double cy, double width, double height, double rx, double ry) {
        this.roundedRect(cx, cy, width, height, rx, ry);
    }

    public void cornerRect(double x, double y, double width, double height) {
        this.addPoint(x, y);
        this.addPoint(x + width, y);
        this.addPoint(x + width, y + height);
        this.addPoint(x, y + height);
        this.close();
    }

    public void cornerRect(Rect r) {
        this.cornerRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public void cornerRect(Rect r, double roundness) {
        this.roundedRect(Rect.corneredRect(r), roundness);
    }

    public void cornerRect(Rect r, double rx, double ry) {
        this.roundedRect(Rect.corneredRect(r), rx, ry);
    }

    public void cornerRect(double cx, double cy, double width, double height, double r) {
        this.roundedRect(Rect.corneredRect(cx, cy, width, height), r);
    }

    public void cornerRect(double cx, double cy, double width, double height, double rx, double ry) {
        this.roundedRect(Rect.corneredRect(cx, cy, width, height), rx, ry);
    }

    public void roundedRect(Rect r, double roundness) {
        this.roundedRect(r, roundness, roundness);
    }

    public void roundedRect(Rect r, double rx, double ry) {
        this.roundedRect(r.getX(), r.getY(), r.getWidth(), r.getHeight(), rx, ry);
    }

    public void roundedRect(double cx, double cy, double width, double height, double r) {
        this.roundedRect(cx, cy, width, height, r, r);
    }

    public void roundedRect(double cx, double cy, double width, double height, double rx, double ry) {
        double halfWidth = width / 2.0;
        double halfHeight = height / 2.0;
        double dx = rx;
        double dy = ry;
        double left = cx - halfWidth;
        double right = cx + halfWidth;
        double top = cy - halfHeight;
        double bottom = cy + halfHeight;
        dx = Math.min(dx, width * 0.5);
        dy = Math.min(dy, height * 0.5);
        this.moveto(left + dx, top);
        if (dx < width * 0.5) {
            this.lineto(right - rx, top);
        }
        this.curveto(right - dx * 0.44799999999999995, top, right, top + dy * 0.44799999999999995, right, top + dy);
        if (dy < height * 0.5) {
            this.lineto(right, bottom - dy);
        }
        this.curveto(right, bottom - dy * 0.44799999999999995, right - dx * 0.44799999999999995, bottom, right - dx, bottom);
        if (dx < width * 0.5) {
            this.lineto(left + dx, bottom);
        }
        this.curveto(left + dx * 0.44799999999999995, bottom, left, bottom - dy * 0.44799999999999995, left, bottom - dy);
        if (dy < height * 0.5) {
            this.lineto(left, top + dy);
        }
        this.curveto(left, top + dy * 0.44799999999999995, left + dx * 0.44799999999999995, top, left + dx, top);
        this.close();
    }

    public void ellipse(double cx, double cy, double width, double height) {
        Ellipse2D.Double e = new Ellipse2D.Double(cx - width / 2.0, cy - height / 2.0, width, height);
        this.extend(e);
    }

    public void cornerEllipse(double x, double y, double width, double height) {
        Ellipse2D.Double e = new Ellipse2D.Double(x, y, width, height);
        this.extend(e);
    }

    public void line(double x1, double y1, double x2, double y2) {
        this.moveto(x1, y1);
        this.lineto(x2, y2);
    }

    public void text(Text t) {
        this.extend(t.getPath());
    }

    public void add(Contour c) {
        this.contours.add(c);
        this.currentContour = c;
        this.invalidate(false);
    }

    public int size() {
        return this.contours.size();
    }

    @Override
    public boolean isEmpty() {
        return this.getPointCount() == 0;
    }

    public void clear() {
        this.contours.clear();
        this.currentContour = null;
        this.invalidate(false);
    }

    public void extend(Path p) {
        for (Contour c : p.contours) {
            this.contours.add(c.clone());
        }
        this.invalidate(false);
    }

    public void extend(Shape s) {
        PathIterator pi = s.getPathIterator(new AffineTransform());
        double px = 0.0;
        double py = 0.0;
        while (!pi.isDone()) {
            double[] points = new double[6];
            int cmd = pi.currentSegment(points);
            if (cmd == 0) {
                px = points[0];
                py = points[1];
                this.moveto(px, py);
            } else if (cmd == 1) {
                px = points[0];
                py = points[1];
                this.lineto(px, py);
            } else if (cmd == 2) {
                double c1x = px + (points[0] - px) * 2.0 / 3.0;
                double c1y = py + (points[1] - py) * 2.0 / 3.0;
                double c2x = points[0] + (points[2] - points[0]) / 3.0;
                double c2y = points[1] + (points[3] - points[1]) / 3.0;
                this.curveto(c1x, c1y, c2x, c2y, points[2], points[3]);
                px = points[2];
                py = points[3];
            } else if (cmd == 3) {
                px = points[4];
                py = points[5];
                this.curveto(points[0], points[1], points[2], points[3], px, py);
            } else if (cmd == 4) {
                py = 0.0;
                px = 0.0;
                this.close();
            } else {
                throw new AssertionError((Object)("Unknown path command " + cmd));
            }
            pi.next();
        }
        this.invalidate(false);
    }

    public List<Contour> getContours() {
        return this.contours;
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        Contour lastContour = this.contours.get(this.contours.size() - 1);
        return lastContour.isClosed();
    }

    public static double lineLength(double x0, double y0, double x1, double y1) {
        x0 = Math.abs(x0 - x1);
        x0 *= x0;
        y0 = Math.abs(y0 - y1);
        y0 *= y0;
        return Math.sqrt(x0 + y0);
    }

    public static Point linePoint(double t, double x0, double y0, double x1, double y1) {
        return new Point(x0 + t * (x1 - x0), y0 + t * (y1 - y0));
    }

    public static double curveLength(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        return Path.curveLength(x0, y0, x1, y1, x2, y2, x3, y3, 20);
    }

    public static double curveLength(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, int n) {
        double length = 0.0;
        double xi = x0;
        double yi = y0;
        for (int i = 0; i < n; ++i) {
            double t = (double)(i + 1) / (double)n;
            Point pt = Path.curvePoint(t, x0, y0, x1, y1, x2, y2, x3, y3);
            double px = pt.getX();
            double py = pt.getY();
            double tmpX = Math.abs(xi - px);
            tmpX *= tmpX;
            double tmpY = Math.abs(yi - py);
            tmpY *= tmpY;
            length += Math.sqrt(tmpX + tmpY);
            xi = px;
            yi = py;
        }
        return length;
    }

    public static Point curvePoint(double t, double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        double mint = 1.0 - t;
        double x01 = x0 * mint + x1 * t;
        double y01 = y0 * mint + y1 * t;
        double x12 = x1 * mint + x2 * t;
        double y12 = y1 * mint + y2 * t;
        double x23 = x2 * mint + x3 * t;
        double y23 = y2 * mint + y3 * t;
        double out_c1x = x01 * mint + x12 * t;
        double out_c1y = y01 * mint + y12 * t;
        double out_c2x = x12 * mint + x23 * t;
        double out_c2y = y12 * mint + y23 * t;
        double out_x = out_c1x * mint + out_c2x * t;
        double out_y = out_c1y * mint + out_c2y * t;
        return new Point(out_x, out_y);
    }

    public double getLength() {
        if (this.lengthDirty) {
            this.updateContourLengths();
        }
        return this.pathLength;
    }

    private void updateContourLengths() {
        this.contourLengths = new ArrayList(this.contours.size());
        this.pathLength = 0.0;
        for (Contour c : this.contours) {
            double length = c.getLength();
            this.contourLengths.add(length);
            this.pathLength += length;
        }
        this.lengthDirty = false;
    }

    public Contour contourAt(double t) {
        double absT = t * this.getLength();
        for (Contour c : this.contours) {
            double cLength = c.getLength();
            if (absT <= cLength) {
                return c;
            }
            absT -= cLength;
        }
        return null;
    }

    @Override
    public Point pointAt(double t) {
        double length = this.getLength();
        double absT = t * length;
        double resT = t;
        Contour currentContour = null;
        Iterator<Contour> i$ = this.contours.iterator();
        while (i$.hasNext()) {
            Contour c;
            currentContour = c = i$.next();
            double cLength = c.getLength();
            if (absT <= cLength) break;
            absT -= cLength;
            resT -= cLength / length;
        }
        if (currentContour == null) {
            return new Point();
        }
        return currentContour.pointAt(resT /= currentContour.getLength() / length);
    }

    public Point point(double t) {
        return this.pointAt(t);
    }

    @Override
    public Point[] makePoints(int amount, boolean perContour) {
        if (perContour) {
            Point[] points = new Point[amount * this.contours.size()];
            int index = 0;
            for (Contour c : this.contours) {
                Point[] pointsFromContour = c.makePoints(amount);
                System.arraycopy(pointsFromContour, 0, points, index, amount);
                index += amount;
            }
            return points;
        }
        double delta = this.pointDelta(amount, this.isClosed());
        Point[] points = new Point[amount];
        for (int i = 0; i < amount; ++i) {
            points[i] = this.pointAt(delta * (double)i);
        }
        return points;
    }

    @Override
    public Path resampleByAmount(int amount, boolean perContour) {
        if (perContour) {
            Path p = this.cloneAndClear();
            for (Contour c : this.contours) {
                p.add(c.resampleByAmount(amount));
            }
            return p;
        }
        Path p = this.cloneAndClear();
        double delta = this.pointDelta(amount, this.isClosed());
        for (int i = 0; i < amount; ++i) {
            p.addPoint(this.pointAt(delta * (double)i));
        }
        if (this.isClosed()) {
            p.close();
        }
        return p;
    }

    @Override
    public Path resampleByLength(double segmentLength) {
        Path p = this.cloneAndClear();
        for (Contour c : this.contours) {
            p.add(c.resampleByLength(segmentLength));
        }
        return p;
    }

    public static Path findPath(List<Point> points) {
        Point[] pts = new Point[points.size()];
        points.toArray(pts);
        return Path.findPath(pts, 1.0);
    }

    public static Path findPath(List<Point> points, double curvature) {
        Point[] pts = new Point[points.size()];
        points.toArray(pts);
        return Path.findPath(pts, curvature);
    }

    public static Path findPath(Point[] points) {
        return Path.findPath(points, 1.0);
    }

    public static Path findPath(Point[] points, double curvature) {
        int i;
        if (points.length == 0) {
            return null;
        }
        if (points.length == 1) {
            Path path = new Path();
            path.moveto(points[0].x, points[0].y);
            return path;
        }
        if (points.length == 2) {
            Path path = new Path();
            path.moveto(points[0].x, points[0].y);
            path.lineto(points[1].x, points[1].y);
            return path;
        }
        if ((curvature = Math.max(0.0, Math.min(1.0, curvature))) == 0.0) {
            Path path = new Path();
            path.moveto(points[0].x, points[0].y);
            for (Point point : points) {
                path.lineto(point.x, point.y);
            }
            return path;
        }
        curvature = 4.0 + (1.0 - curvature) * 40.0;
        HashMap<Integer, Double> dx = new HashMap<Integer, Double>();
        HashMap<Integer, Double> dy = new HashMap<Integer, Double>();
        HashMap<Integer, Double> bi = new HashMap<Integer, Double>();
        HashMap<Integer, Double> ax = new HashMap<Integer, Double>();
        HashMap<Integer, Double> ay = new HashMap<Integer, Double>();
        dx.put(0, 0.0);
        dx.put(points.length - 1, 0.0);
        dy.put(0, 0.0);
        dy.put(points.length - 1, 0.0);
        bi.put(1, 1.0 / curvature);
        ax.put(1, (points[2].x - points[0].x - (Double)dx.get(0)) * (Double)bi.get(1));
        ay.put(1, (points[2].y - points[0].y - (Double)dy.get(0)) * (Double)bi.get(1));
        for (i = 2; i < points.length - 1; ++i) {
            bi.put(i, -1.0 / (curvature + (Double)bi.get(i - 1)));
            ax.put(i, -(points[i + 1].x - points[i - 1].x - (Double)ax.get(i - 1)) * (Double)bi.get(i));
            ay.put(i, -(points[i + 1].y - points[i - 1].y - (Double)ay.get(i - 1)) * (Double)bi.get(i));
        }
        for (i = points.length - 2; i >= 1; --i) {
            dx.put(i, (Double)ax.get(i) + (Double)dx.get(i + 1) * (Double)bi.get(i));
            dy.put(i, (Double)ay.get(i) + (Double)dy.get(i + 1) * (Double)bi.get(i));
        }
        Path path = new Path();
        path.moveto(points[0].x, points[0].y);
        for (int i2 = 0; i2 < points.length - 1; ++i2) {
            path.curveto(points[i2].x + (Double)dx.get(i2), points[i2].y + (Double)dy.get(i2), points[i2 + 1].x - (Double)dx.get(i2 + 1), points[i2 + 1].y - (Double)dy.get(i2 + 1), points[i2 + 1].x, points[i2 + 1].y);
        }
        return path;
    }

    public boolean contains(Point p) {
        return this.getGeneralPath().contains(p.toPoint2D());
    }

    public boolean contains(double x, double y) {
        return this.getGeneralPath().contains(x, y);
    }

    public boolean contains(Rect r) {
        return this.getGeneralPath().contains(r.getRectangle2D());
    }

    public boolean intersects(Rect r) {
        return this.getGeneralPath().intersects(r.getRectangle2D());
    }

    public boolean intersects(Path p) {
        Area a1 = new Area(this.getGeneralPath());
        Area a2 = new Area(p.getGeneralPath());
        a1.intersect(a2);
        return !a1.isEmpty();
    }

    public Path intersected(Path p) {
        Area a1 = new Area(this.getGeneralPath());
        Area a2 = new Area(p.getGeneralPath());
        a1.intersect(a2);
        return new Path(a1);
    }

    public Path subtracted(Path p) {
        Area a1 = new Area(this.getGeneralPath());
        Area a2 = new Area(p.getGeneralPath());
        a1.subtract(a2);
        return new Path(a1);
    }

    public Path united(Path p) {
        Area a1 = new Area(this.getGeneralPath());
        Area a2 = new Area(p.getGeneralPath());
        a1.add(a2);
        return new Path(a1);
    }

    public GeneralPath getGeneralPath() {
        if (!this.pathDirty) {
            return this.awtPath;
        }
        GeneralPath gp = new GeneralPath(1);
        for (Contour c : this.contours) {
            c._extendPath(gp);
        }
        this.awtPath = gp;
        this.pathDirty = false;
        return gp;
    }

    @Override
    public Rect getBounds() {
        if (!this.pathDirty && this.bounds != null) {
            return this.bounds;
        }
        if (this.isEmpty()) {
            this.bounds = new Rect();
        } else {
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            double maxY = -1.7976931348623157E308;
            ArrayList points = (ArrayList)this.getPoints();
            for (int i = 0; i < this.getPointCount(); ++i) {
                Point p = (Point)points.get(i);
                if (p.getType() == 1) {
                    double px = p.getX();
                    double py = p.getY();
                    if (px < minX) {
                        minX = px;
                    }
                    if (py < minY) {
                        minY = py;
                    }
                    if (px > maxX) {
                        maxX = px;
                    }
                    if (!(py > maxY)) continue;
                    maxY = py;
                    continue;
                }
                if (p.getType() != 2) continue;
                Bezier b = new Bezier((Point)points.get(i - 3), (Point)points.get(i - 2), (Point)points.get(i - 1), p);
                Rect r = b.extrema();
                double right = r.getX() + r.getWidth();
                double bottom = r.getY() + r.getHeight();
                if (r.getX() < minX) {
                    minX = r.getX();
                }
                if (right > maxX) {
                    maxX = right;
                }
                if (r.getY() < minY) {
                    minY = r.getY();
                }
                if (!(bottom > maxY)) continue;
                maxY = bottom;
            }
            this.bounds = new Rect(minX, minY, maxX - minX, maxY - minY);
        }
        return this.bounds;
    }

    @Override
    public void transform(Transform t) {
        for (Contour c : this.contours) {
            c.setPoints(t.map(c.getPoints()));
        }
        this.invalidate(true);
    }

    @Override
    public void flatten() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public Path flattened() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.fillColor == null && this.strokeColor == null) {
            return;
        }
        GeneralPath gp = this.getGeneralPath();
        if (this.fillColor != null) {
            this.fillColor.set(g);
            g.fill(gp);
        }
        if (this.strokeWidth > 0.0 && this.strokeColor != null) {
            try {
                this.strokeColor.set(g);
                g.setStroke(new BasicStroke((float)this.strokeWidth));
                g.draw(gp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Path clone() {
        return new Path(this);
    }

    public Path cloneAndClear() {
        return new Path(this, false);
    }

    @Override
    public AbstractGeometry mapPoints(Function<Point, Point> pointFunction) {
        Path newPath = this.cloneAndClear();
        for (Contour c : this.getContours()) {
            Contour newContour = (Contour)c.mapPoints(pointFunction);
            newPath.add(newContour);
        }
        return newPath;
    }

    @Override
    public Iterator<Point> iterator() {
        return this.getPoints().iterator();
    }

    public String toString() {
        return "<Path>";
    }

    private class Bezier {
        private double x1;
        private double y1;
        private double x2;
        private double y2;
        private double x3;
        private double y3;
        private double x4;
        private double y4;
        private double minx;
        private double maxx;
        private double miny;
        private double maxy;

        public Bezier(Point p1, Point p2, Point p3, Point p4) {
            this.x1 = p1.getX();
            this.y1 = p1.getY();
            this.x2 = p2.getX();
            this.y2 = p2.getY();
            this.x3 = p3.getX();
            this.y3 = p3.getY();
            this.x4 = p4.getX();
            this.y4 = p4.getY();
        }

        private boolean fuzzyCompare(double p1, double p2) {
            return Math.abs(p1 - p2) <= 1.0E-12 * Math.min(Math.abs(p1), Math.abs(p2));
        }

        public Point pointAt(double t) {
            double[] coeff = this.coefficients(t);
            double a = coeff[0];
            double b = coeff[1];
            double c = coeff[2];
            double d = coeff[3];
            return new Point(a * this.x1 + b * this.x2 + c * this.x3 + d * this.x4, a * this.y1 + b * this.y2 + c * this.y3 + d * this.y4);
        }

        private double[] coefficients(double t) {
            double m_t = 1.0 - t;
            double b = m_t * m_t;
            double c = t * t;
            double d = c * t;
            double a = b * m_t;
            return new double[]{a, b *= 3.0 * t, c *= 3.0 * m_t, d};
        }

        private void bezierCheck(double t) {
            if (t >= 0.0 && t <= 1.0) {
                Point p = this.pointAt(t);
                if (p.getX() < this.minx) {
                    this.minx = p.getX();
                } else if (p.getX() > this.maxx) {
                    this.maxx = p.getX();
                }
                if (p.getY() < this.miny) {
                    this.miny = p.getY();
                } else if (p.getY() > this.maxy) {
                    this.maxy = p.getY();
                }
            }
        }

        public Rect extrema() {
            double t2;
            double t1;
            double rcp;
            double temp;
            double t;
            if (this.x1 < this.x4) {
                this.minx = this.x1;
                this.maxx = this.x4;
            } else {
                this.minx = this.x4;
                this.maxx = this.x1;
            }
            if (this.y1 < this.y4) {
                this.miny = this.y1;
                this.maxy = this.y4;
            } else {
                this.miny = this.y4;
                this.maxy = this.y1;
            }
            double ax = 3.0 * (-this.x1 + 3.0 * this.x2 - 3.0 * this.x3 + this.x4);
            double bx = 6.0 * (this.x1 - 2.0 * this.x2 + this.x3);
            double cx = 3.0 * (-this.x1 + this.x2);
            if (this.fuzzyCompare(ax + 1.0, 1.0)) {
                if (!this.fuzzyCompare(bx + 1.0, 1.0)) {
                    t = -cx / bx;
                    this.bezierCheck(t);
                }
            } else {
                double tx = bx * bx - 4.0 * ax * cx;
                if (tx >= 0.0) {
                    temp = Math.sqrt(tx);
                    rcp = 1.0 / (2.0 * ax);
                    t1 = (-bx + temp) * rcp;
                    this.bezierCheck(t1);
                    t2 = (-bx - temp) * rcp;
                    this.bezierCheck(t2);
                }
            }
            double ay = 3.0 * (-this.y1 + 3.0 * this.y2 - 3.0 * this.y3 + this.y4);
            double by = 6.0 * (this.y1 - 2.0 * this.y2 + this.y3);
            double cy = 3.0 * (-this.y1 + this.y2);
            if (this.fuzzyCompare(ay + 1.0, 1.0)) {
                if (!this.fuzzyCompare(by + 1.0, 1.0)) {
                    t = -cy / by;
                    this.bezierCheck(t);
                }
            } else {
                double ty = by * by - 4.0 * ay * cy;
                if (ty > 0.0) {
                    temp = Math.sqrt(ty);
                    rcp = 1.0 / (2.0 * ay);
                    t1 = (-by + temp) * rcp;
                    this.bezierCheck(t1);
                    t2 = (-by - temp) * rcp;
                    this.bezierCheck(t2);
                }
            }
            return new Rect(this.minx, this.miny, this.maxx - this.minx, this.maxy - this.miny);
        }
    }
}

