/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import nodebox.graphics.Point;

public class PathElement {
    public static final int MOVETO = 0;
    public static final int LINETO = 1;
    public static final int CURVETO = 2;
    public static final int CLOSE = 3;
    private final int command;
    private final Point point;
    private final Point control1;
    private final Point control2;

    public PathElement() {
        this(0, Point.ZERO, Point.ZERO, Point.ZERO);
    }

    public PathElement(int command) {
        Preconditions.checkArgument((command == 3 ? 1 : 0) != 0, (Object)"Command needs to be CLOSE.");
        this.command = 3;
        this.point = Point.ZERO;
        this.control1 = Point.ZERO;
        this.control2 = Point.ZERO;
    }

    public PathElement(int command, double x, double y) {
        Preconditions.checkArgument((command == 0 || command == 1 ? 1 : 0) != 0, (Object)"Command needs to be MOVETO or LINETO.");
        this.command = command;
        this.point = new Point(x, y);
        this.control1 = Point.ZERO;
        this.control2 = Point.ZERO;
    }

    public PathElement(int command, double x1, double y1, double x2, double y2, double x3, double y3) {
        Preconditions.checkArgument((command == 2 ? 1 : 0) != 0, (Object)"Command needs to be CURVETO.");
        this.command = command;
        this.control1 = new Point(x1, y1);
        this.control2 = new Point(x2, y2);
        this.point = new Point(x3, y3);
    }

    public PathElement(int command, double[] points) {
        this.command = command;
        switch (command) {
            case 0: 
            case 1: {
                Preconditions.checkArgument((points.length == 2 ? 1 : 0) != 0, (Object)"MOVETO or LINETO commands requires 2 points.");
                this.point = new Point(points[0], points[1]);
                this.control1 = Point.ZERO;
                this.control2 = Point.ZERO;
                break;
            }
            case 2: {
                Preconditions.checkArgument((points.length == 6 ? 1 : 0) != 0, (Object)"CURVETO command requires 6 points.");
                this.control1 = new Point(points[0], points[1]);
                this.control2 = new Point(points[2], points[3]);
                this.point = new Point(points[4], points[5]);
                break;
            }
            case 3: {
                Preconditions.checkArgument((points.length == 0 ? 1 : 0) != 0, (Object)"CLOSE command requires no points.");
                this.point = Point.ZERO;
                this.control1 = Point.ZERO;
                this.control2 = Point.ZERO;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown command" + command);
            }
        }
    }

    public PathElement(int command, Point point, Point control1, Point control2) {
        this.command = command;
        this.point = point;
        this.control1 = control1;
        this.control2 = control2;
    }

    public int getCommand() {
        return this.command;
    }

    public Point getPoint() {
        return this.point;
    }

    public double getX() {
        return this.point.getX();
    }

    public double getY() {
        return this.point.getY();
    }

    public Point getControl1() {
        return this.control1;
    }

    public Point getControl2() {
        return this.control2;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PathElement)) {
            return false;
        }
        PathElement other = (PathElement)o;
        return Objects.equal((Object)this.command, (Object)other.command) && Objects.equal((Object)this.point, (Object)other.point) && Objects.equal((Object)this.control1, (Object)other.control1) && Objects.equal((Object)this.control2, (Object)other.control2);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.command, this.point, this.control1, this.control2});
    }

    public String toString() {
        switch (this.command) {
            case 0: {
                return "PathElement(Command.MOVETO, " + this.getX() + ", " + this.getY() + ")";
            }
            case 1: {
                return "PathElement(Command.LINETO, " + this.getX() + ", " + this.getY() + ")";
            }
            case 2: {
                return "PathElement(Command.CURVETO, " + this.getControl1().getX() + ", " + this.getControl1().getY() + ", " + this.getControl2().getX() + ", " + this.getControl2().getY() + ", " + this.getX() + ", " + this.getY() + ")";
            }
            case 3: {
                return "PathElement(Command.CLOSE)";
            }
        }
        throw new AssertionError((Object)("Invalid PathElement command " + this.command));
    }
}

