/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.awt.geom.Point2D;
import java.util.Locale;

public final class Point {
    public static final Point ZERO = new Point(0.0, 0.0);
    public static final int LINE_TO = 1;
    public static final int CURVE_TO = 2;
    public static final int CURVE_DATA = 3;
    public final double x;
    public final double y;
    public final int type;
    public transient int hashCode;

    public static Point valueOf(String s) {
        String[] args = s.split(",");
        Preconditions.checkArgument((args.length == 2 ? 1 : 0) != 0, (Object)("String '" + s + "' needs two components, i.e. 12.3,45.6"));
        return new Point(Float.valueOf(args[0]).floatValue(), Float.valueOf(args[1]).floatValue());
    }

    public static Point parsePoint(String s) {
        return Point.valueOf(s);
    }

    public Point() {
        this(0.0, 0.0, 1);
    }

    public Point(double x, double y) {
        this(x, y, 1);
    }

    public Point(double x, double y, int type) {
        this.x = x;
        this.y = y;
        this.type = type;
    }

    public Point(Point2D pt) {
        this(pt.getX(), pt.getY(), 1);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getType() {
        return this.type;
    }

    public boolean isLineTo() {
        return this.type == 1;
    }

    public boolean isCurveTo() {
        return this.type == 2;
    }

    public boolean isCurveData() {
        return this.type == 3;
    }

    public boolean isOnCurve() {
        return this.type != 3;
    }

    public boolean isOffCurve() {
        return this.type == 3;
    }

    public Point moved(double dx, double dy) {
        return new Point(this.x + dx, this.y + dy);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        return Objects.equal((Object)this.x, (Object)other.x) && Objects.equal((Object)this.y, (Object)other.y) && Objects.equal((Object)this.type, (Object)other.type);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hashCode((Object[])new Object[]{this.x, this.y, this.type});
        }
        return this.hashCode;
    }

    public String toString() {
        return String.format(Locale.US, "%.2f,%.2f", this.x, this.y);
    }

    public Point2D toPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }
}

