/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import nodebox.graphics.Point;

public class Rect
implements Iterable {
    public final double x;
    public final double y;
    public final double width;
    public final double height;

    public static Rect centeredRect(double cx, double cy, double width, double height) {
        return new Rect(cx - width / 2.0, cy - height / 2.0, width, height);
    }

    public static Rect centeredRect(Rect r) {
        return Rect.centeredRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public static Rect corneredRect(double cx, double cy, double width, double height) {
        return new Rect(cx + width / 2.0, cy + height / 2.0, width, height);
    }

    public static Rect corneredRect(Rect r) {
        return Rect.corneredRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public Rect() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public Rect(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rect(Rect r) {
        this(r.x, r.y, r.width, r.height);
    }

    public Rect(Rectangle2D r) {
        this(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Point getPosition() {
        return new Point(this.x, this.y);
    }

    public Point getCentroid() {
        return new Point(this.x + this.width / 2.0, this.y + this.height / 2.0);
    }

    public boolean isEmpty() {
        Rect n = this.normalized();
        return n.width <= 0.0 || n.height <= 0.0;
    }

    public Rect normalized() {
        double x = this.x;
        double y = this.y;
        double width = this.width;
        double height = this.height;
        if (width < 0.0) {
            x += width;
            width = -width;
        }
        if (height < 0.0) {
            y += height;
            height = -height;
        }
        return new Rect(x, y, width, height);
    }

    public Rect united(Rect r) {
        Rect r1 = this.normalized();
        Rect r2 = r.normalized();
        double x = Math.min(r1.x, r2.x);
        double y = Math.min(r1.y, r2.y);
        double width = Math.max(r1.x + r1.width, r2.x + r2.width) - x;
        double height = Math.max(r1.y + r1.height, r2.y + r2.height) - y;
        return new Rect(x, y, width, height);
    }

    public boolean intersects(Rect r) {
        Rect r1 = this.normalized();
        Rect r2 = r.normalized();
        return Math.max(r1.x, r1.y) < Math.min(r1.x + r1.width, r2.width) && Math.max(r1.y, r2.y) < Math.min(r1.y + r1.height, r2.y + r2.height);
    }

    public boolean contains(Point p) {
        Rect r = this.normalized();
        return p.getX() >= r.x && p.getX() <= r.x + r.width && p.getY() >= r.y && p.getY() <= r.y + r.height;
    }

    public boolean contains(Rect r) {
        Rect r1 = this.normalized();
        Rect r2 = r.normalized();
        return r2.x >= r1.x && r2.x + r2.width <= r1.x + r1.width && r2.y >= r1.y && r2.y + r2.height <= r1.y + r1.height;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Rect)) {
            return false;
        }
        Rect other = (Rect)o;
        return Objects.equal((Object)this.x, (Object)other.x) && Objects.equal((Object)this.y, (Object)other.y) && Objects.equal((Object)this.width, (Object)other.width) && Objects.equal((Object)this.height, (Object)other.height);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.x, this.y, this.width, this.height});
    }

    public String toString() {
        return "Rect(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ")";
    }

    public Rectangle2D getRectangle2D() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public Iterator<Double> iterator() {
        return ImmutableList.of((Object)this.x, (Object)this.y, (Object)this.width, (Object)this.height).iterator();
    }
}

