/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Iterator;

public class Size
implements Iterable {
    private double width;
    private double height;

    public Size() {
        this(0.0, 0.0);
    }

    public Size(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public Size(Size sz) {
        this.width = sz.width;
        this.height = sz.height;
    }

    public Size(Dimension2D d) {
        this.width = d.getWidth();
        this.height = d.getHeight();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Dimension2D getDimension2D() {
        return new Dimension(this.width, this.height);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Size)) {
            return false;
        }
        Size sz = (Size)o;
        return this.width == sz.width && this.height == sz.height;
    }

    public String toString() {
        return "Size(" + this.width + ", " + this.height + ")";
    }

    public Iterator<Double> iterator() {
        ArrayList<Double> list = new ArrayList<Double>();
        list.add(this.width);
        list.add(this.height);
        return list.iterator();
    }

    public Size clone() {
        return new Size(this);
    }

    private class Dimension
    extends Dimension2D {
        private double width;
        private double height;

        private Dimension(double width, double height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public void setSize(double width, double height) {
            this.width = width;
            this.height = height;
        }
    }
}

