/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.Iterator;
import nodebox.graphics.AbstractGrob;
import nodebox.graphics.Color;
import nodebox.graphics.Path;
import nodebox.graphics.Point;
import nodebox.graphics.Rect;

public class Text
extends AbstractGrob {
    private String text;
    private double baseLineX;
    private double baseLineY;
    private double width = 0.0;
    private double height = 0.0;
    private String fontName = "Helvetica";
    private double fontSize = 24.0;
    private double lineHeight = 1.2;
    private Align align = Align.CENTER;
    private Color fillColor = new Color();

    public Text(String text, Point pt) {
        this.text = text;
        this.baseLineX = pt.getX();
        this.baseLineY = pt.getY();
    }

    public Text(String text, double baseLineX, double baseLineY) {
        this.text = text;
        this.baseLineX = baseLineX;
        this.baseLineY = baseLineY;
    }

    public Text(String text, Rect r) {
        this.text = text;
        this.baseLineX = r.getX();
        this.baseLineY = r.getY();
        this.width = r.getWidth();
        this.height = r.getHeight();
    }

    public Text(String text, double x, double y, double width, double height) {
        this.text = text;
        this.baseLineX = x;
        this.baseLineY = y;
        this.width = width;
        this.height = height;
    }

    public Text(Text other) {
        super(other);
        this.text = other.text;
        this.baseLineX = other.baseLineX;
        this.baseLineY = other.baseLineY;
        this.width = other.width;
        this.height = other.height;
        this.fontName = other.fontName;
        this.fontSize = other.fontSize;
        this.lineHeight = other.lineHeight;
        this.align = other.align;
        this.fillColor = other.fillColor == null ? null : other.fillColor.clone();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getBaseLineX() {
        return this.baseLineX;
    }

    public void setBaseLineX(double baseLineX) {
        this.baseLineX = baseLineX;
    }

    public double getBaseLineY() {
        return this.baseLineY;
    }

    public void setBaseLineY(double baseLineY) {
        this.baseLineY = baseLineY;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(double fontSize) {
        this.fontSize = fontSize;
    }

    public Font getFont() {
        return new Font(this.fontName, 0, (int)this.fontSize);
    }

    public double getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(double lineHeight) {
        this.lineHeight = lineHeight;
    }

    public Align getAlign() {
        return this.align;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public static boolean fontExists(String fontName) {
        Font[] allFonts;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (Font font : allFonts = env.getAllFonts()) {
            if (!font.getName().equals(fontName)) continue;
            return true;
        }
        return false;
    }

    private AttributedString getStyledText(String text) {
        if (text.length() == 0) {
            text = " ";
        }
        AttributedString attrString = new AttributedString(text);
        attrString.addAttribute(TextAttribute.FONT, this.getFont());
        if (this.fillColor != null) {
            attrString.addAttribute(TextAttribute.FOREGROUND, this.fillColor.getAwtColor());
        }
        if (this.align != Align.RIGHT && this.align != Align.CENTER && this.align == Align.JUSTIFY) {
            attrString.addAttribute(TextAttribute.JUSTIFICATION, TextAttribute.JUSTIFICATION_FULL);
        }
        return attrString;
    }

    public Rect getMetrics() {
        if (this.text == null || this.text.length() == 0) {
            return new Rect();
        }
        TextLayoutIterator iterator = new TextLayoutIterator();
        Rectangle2D bounds = new Rectangle2D.Double();
        while (iterator.hasNext()) {
            TextLayout layout = iterator.next();
            bounds = ((Rectangle2D)bounds).createUnion(layout.getBounds());
        }
        return new Rect(bounds);
    }

    protected void setupTransform(Graphics2D g) {
        this.saveTransform(g);
        AffineTransform trans = g.getTransform();
        trans.concatenate(this.getTransform().getAffineTransform());
        g.setTransform(trans);
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.fillColor == null) {
            return;
        }
        this.setupTransform(g);
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        TextLayoutIterator iterator = new TextLayoutIterator();
        while (iterator.hasNext()) {
            TextLayout layout = iterator.next();
            layout.draw(g, (float)(this.baseLineX + iterator.getX()), (float)(this.baseLineY + iterator.getY()));
        }
        this.restoreTransform(g);
    }

    public Path getPath() {
        Path p = new Path();
        p.setFillColor(this.fillColor == null ? null : this.fillColor.clone());
        TextLayoutIterator iterator = new TextLayoutIterator();
        while (iterator.hasNext()) {
            TextLayout layout = iterator.next();
            AffineTransform trans = new AffineTransform();
            trans.translate(this.baseLineX + iterator.getX(), this.baseLineY + iterator.getY());
            Shape shape = layout.getOutline(trans);
            p.extend(shape);
        }
        p.transform(this.getTransform());
        return p;
    }

    @Override
    public boolean isEmpty() {
        return this.text.trim().length() == 0;
    }

    @Override
    public Rect getBounds() {
        return this.getPath().getBounds();
    }

    @Override
    public Text clone() {
        return new Text(this);
    }

    private class TextLayoutIterator
    implements Iterator<TextLayout> {
        private double x = 0.0;
        private double y = 0.0;
        private double ascent;
        private int currentIndex = 0;
        private String[] textParts;
        private LineBreakMeasurer[] measurers;
        private LineBreakMeasurer currentMeasurer;
        private String currentText;
        private boolean first;

        private TextLayoutIterator() {
            this.textParts = Text.this.text.split("\n");
            this.measurers = new LineBreakMeasurer[this.textParts.length];
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
            for (int i = 0; i < this.textParts.length; ++i) {
                AttributedString s = Text.this.getStyledText(this.textParts[i]);
                this.measurers[i] = new LineBreakMeasurer(s.getIterator(), frc);
            }
            this.currentMeasurer = this.measurers[this.currentIndex];
            this.currentText = this.textParts[this.currentIndex];
            this.first = true;
        }

        @Override
        public boolean hasNext() {
            if (this.currentMeasurer.getPosition() < this.currentText.length()) {
                return true;
            }
            ++this.currentIndex;
            if (this.currentIndex < this.textParts.length) {
                this.currentMeasurer = this.measurers[this.currentIndex];
                this.currentText = this.textParts[this.currentIndex];
                return this.hasNext();
            }
            return false;
        }

        @Override
        public TextLayout next() {
            if (this.first) {
                this.first = false;
            } else {
                this.y += this.ascent * Text.this.lineHeight;
            }
            double layoutWidth = Text.this.width == 0.0 ? 3.4028234663852886E38 : Text.this.width;
            TextLayout layout = this.currentMeasurer.nextLayout((float)layoutWidth);
            if (Text.this.width == 0.0) {
                layoutWidth = layout.getAdvance();
                if (Text.this.align == Align.RIGHT) {
                    this.x = -layoutWidth;
                } else if (Text.this.align == Align.CENTER) {
                    this.x = -layoutWidth / 2.0;
                }
            } else if (Text.this.align == Align.RIGHT) {
                this.x = Text.this.width - (double)layout.getAdvance();
            } else if (Text.this.align == Align.CENTER) {
                this.x = (Text.this.width - (double)layout.getAdvance()) / 2.0;
            } else if (Text.this.align == Align.JUSTIFY && this.currentMeasurer.getPosition() < this.currentText.length()) {
                layout = layout.getJustifiedLayout((float)Text.this.width);
            }
            this.ascent = layout.getAscent();
            return layout;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        @Override
        public void remove() {
            throw new AssertionError((Object)"This operation is not implemented");
        }
    }

    public static enum Align {
        LEFT,
        RIGHT,
        CENTER,
        JUSTIFY;

    }
}

