/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import nodebox.graphics.Contour;
import nodebox.graphics.Geometry;
import nodebox.graphics.IGeometry;
import nodebox.graphics.Path;
import nodebox.graphics.Point;
import nodebox.graphics.Rect;

public class Transform
implements Cloneable {
    private AffineTransform affineTransform;

    public static Transform translated(double tx, double ty) {
        Transform t = new Transform();
        t.translate(tx, ty);
        return t;
    }

    public static Transform translated(Point t) {
        return Transform.translated(t.x, t.y);
    }

    public static Transform rotated(double degrees) {
        Transform t = new Transform();
        t.rotate(degrees);
        return t;
    }

    public static Transform rotatedRadians(double radians) {
        Transform t = new Transform();
        t.rotateRadians(radians);
        return t;
    }

    public static Transform scaled(double scale) {
        Transform t = new Transform();
        t.scale(scale);
        return t;
    }

    public static Transform scaled(double sx, double sy) {
        Transform t = new Transform();
        t.scale(sx, sy);
        return t;
    }

    public static Transform scaled(Point s) {
        return Transform.scaled(s.x, s.y);
    }

    public static Transform skewed(double skew) {
        Transform t = new Transform();
        t.skew(skew);
        return t;
    }

    public static Transform skewed(double kx, double ky) {
        Transform t = new Transform();
        t.skew(kx, ky);
        return t;
    }

    public Transform() {
        this.affineTransform = new AffineTransform();
    }

    public Transform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.affineTransform = new AffineTransform(m00, m10, m01, m11, m02, m12);
    }

    public Transform(AffineTransform affineTransform) {
        this.affineTransform = affineTransform;
    }

    public Transform(Transform other) {
        this.affineTransform = (AffineTransform)other.affineTransform.clone();
    }

    public void translate(Point point) {
        this.affineTransform.translate(point.x, point.y);
    }

    public void translate(double tx, double ty) {
        this.affineTransform.translate(tx, ty);
    }

    public void rotate(double degrees) {
        double radians = degrees * Math.PI / 180.0;
        this.affineTransform.rotate(radians);
    }

    public void rotateRadians(double radians) {
        this.affineTransform.rotate(radians);
    }

    public void scale(double scale) {
        this.affineTransform.scale(scale, scale);
    }

    public void scale(double sx, double sy) {
        this.affineTransform.scale(sx, sy);
    }

    public void skew(double skew) {
        this.skew(skew, skew);
    }

    public void skew(double kx, double ky) {
        kx = Math.PI * kx / 180.0;
        ky = Math.PI * ky / 180.0;
        this.affineTransform.concatenate(new AffineTransform(1.0, Math.tan(ky), -Math.tan(kx), 1.0, 0.0, 0.0));
    }

    public boolean invert() {
        try {
            this.affineTransform = this.affineTransform.createInverse();
            return true;
        }
        catch (NoninvertibleTransformException e) {
            return false;
        }
    }

    public void append(Transform t) {
        this.affineTransform.concatenate(t.affineTransform);
    }

    public void prepend(Transform t) {
        this.affineTransform.preConcatenate(t.affineTransform);
    }

    public Point map(Point p) {
        Point2D.Double p2 = new Point2D.Double();
        this.affineTransform.transform(p.toPoint2D(), p2);
        return new Point(p2);
    }

    public Rect map(Rect r) {
        Point2D.Double origin = new Point2D.Double(r.getX(), r.getY());
        Point2D.Double size = new Point2D.Double(r.getWidth(), r.getHeight());
        Point2D.Double transformedOrigin = new Point2D.Double();
        Point2D.Double transformedSize = new Point2D.Double();
        this.affineTransform.transform(origin, transformedOrigin);
        this.affineTransform.deltaTransform(size, transformedSize);
        return new Rect(((Point2D)transformedOrigin).getX(), ((Point2D)transformedOrigin).getY(), ((Point2D)transformedSize).getX(), ((Point2D)transformedSize).getY());
    }

    public IGeometry map(IGeometry shape) {
        if (shape instanceof Path) {
            return this.map((Path)shape);
        }
        if (shape instanceof Geometry) {
            return this.map((Geometry)shape);
        }
        throw new RuntimeException("Unsupported geometry type " + shape);
    }

    public Path map(Path p) {
        Path newPath = new Path(p, false);
        for (Contour c : p.getContours()) {
            Contour newContour = new Contour(this.map(c.getPoints()), c.isClosed());
            newPath.add(newContour);
        }
        return newPath;
    }

    public Geometry map(Geometry g) {
        Geometry newGeometry = new Geometry();
        for (Path p : g.getPaths()) {
            Path newPath = this.map(p);
            newGeometry.add(newPath);
        }
        return newGeometry;
    }

    public List<Point> map(List<Point> points) {
        double[] coords = new double[points.size() * 2];
        int i = 0;
        for (Point pt : points) {
            coords[i++] = pt.x;
            coords[i++] = pt.y;
        }
        this.affineTransform.transform(coords, 0, coords, 0, points.size());
        ArrayList<Point> transformed = new ArrayList<Point>(points.size());
        int pointIndex = 0;
        for (i = 0; i < coords.length; i += 2) {
            transformed.add(new Point(coords[i], coords[i + 1], points.get((int)pointIndex).type));
            ++pointIndex;
        }
        return transformed;
    }

    public Rect convertBoundsToFrame(Rect bounds) {
        AffineTransform t = this.fullTransform(bounds);
        Point2D.Double transformedOrigin = new Point2D.Double();
        Point2D.Double transformedSize = new Point2D.Double();
        t.transform(new Point2D.Double(bounds.getX(), bounds.getY()), transformedOrigin);
        t.deltaTransform(new Point2D.Double(bounds.getWidth(), bounds.getHeight()), transformedSize);
        return new Rect(((Point2D)transformedOrigin).getX(), ((Point2D)transformedOrigin).getY(), ((Point2D)transformedSize).getX(), ((Point2D)transformedSize).getY());
    }

    private AffineTransform fullTransform(Rect bounds) {
        double cx = bounds.getX() + bounds.getWidth() / 2.0;
        double cy = bounds.getY() + bounds.getHeight() / 2.0;
        AffineTransform t = new AffineTransform();
        t.translate(cx, cy);
        t.preConcatenate(this.affineTransform);
        t.translate(-cx, -cy);
        return t;
    }

    protected Transform clone() {
        return new Transform(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Transform)) {
            return false;
        }
        return this.getAffineTransform().equals(((Transform)obj).getAffineTransform());
    }

    public void apply(Graphics2D g, Rect bounds) {
        AffineTransform t = this.fullTransform(bounds);
        g.transform(t);
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public static enum Mode {
        CORNER,
        CENTER;

    }
}

