/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.amazon.s3;

import java.util.Map;
import net.noderunner.amazon.s3.Bucket;
import net.noderunner.amazon.s3.UrlEncoder;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CallingFormat {
    public static final CallingFormat PATH = new PathCallingFormat();
    public static final CallingFormat SUBDOMAIN = new SubdomainCallingFormat();
    public static final CallingFormat VANITY = new VanityCallingFormat();

    public abstract boolean supportsLocatedBuckets();

    public abstract String getEndpoint(String var1, int var2, Bucket var3);

    public abstract String getPathBase(Bucket var1, String var2);

    public abstract URI getURI(boolean var1, String var2, int var3, Bucket var4, String var5, Map<String, String> var6) throws URIException;

    private static URI addQuery(HttpURL uri, Map<String, String> pathArgs) throws URIException {
        if (pathArgs == null || pathArgs.isEmpty()) {
            return uri;
        }
        int size = pathArgs.size();
        String[] name = new String[size];
        String[] value = new String[size];
        int i = 0;
        for (Map.Entry<String, String> me : pathArgs.entrySet()) {
            name[i] = me.getKey();
            value[i] = me.getValue();
            if (value[i] == null) {
                throw new NullPointerException("query cannot contain null " + pathArgs);
            }
            ++i;
        }
        uri.setQuery(name, value);
        return uri;
    }

    private static URI url(boolean isSecure, String host, int port, String path, Map<String, String> pathArgs) throws URIException {
        HttpsURL url = isSecure ? new HttpsURL(host, port, "/") : new HttpURL(host, port, "/");
        url.setEscapedPath(path);
        return CallingFormat.addQuery((HttpURL)url, pathArgs);
    }

    private static class VanityCallingFormat
    extends SubdomainCallingFormat {
        private VanityCallingFormat() {
        }

        public String getServer(String server, Bucket bucket) {
            return bucket.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubdomainCallingFormat
    extends CallingFormat {
        private SubdomainCallingFormat() {
        }

        @Override
        public boolean supportsLocatedBuckets() {
            return true;
        }

        public String getServer(String server, Bucket bucket) {
            return bucket + "." + server;
        }

        @Override
        public String getEndpoint(String server, int port, Bucket bucket) {
            return this.getServer(server, bucket) + ":" + port;
        }

        @Override
        public String getPathBase(Bucket bucket, String key) {
            return "/" + UrlEncoder.encode(key);
        }

        @Override
        public URI getURI(boolean isSecure, String server, int port, Bucket bucket, String key, Map<String, String> pathArgs) throws URIException {
            if (bucket == null || !bucket.specified()) {
                return CallingFormat.url(isSecure, server, port, "", pathArgs);
            }
            String serverToUse = this.getServer(server, bucket);
            String pathBase = this.getPathBase(bucket, key);
            return CallingFormat.url(isSecure, serverToUse, port, pathBase, pathArgs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathCallingFormat
    extends CallingFormat {
        private PathCallingFormat() {
        }

        @Override
        public boolean supportsLocatedBuckets() {
            return false;
        }

        @Override
        public String getPathBase(Bucket bucket, String key) {
            return this.isBucketSpecified(bucket) ? "/" + bucket + "/" + UrlEncoder.encode(key) : "/";
        }

        @Override
        public String getEndpoint(String server, int port, Bucket bucket) {
            return server + ":" + port;
        }

        @Override
        public URI getURI(boolean isSecure, String server, int port, Bucket bucket, String key, Map<String, String> pathArgs) throws URIException {
            String pathBase = this.isBucketSpecified(bucket) ? "/" + bucket + "/" + UrlEncoder.encode(key) : "/";
            return CallingFormat.url(isSecure, server, port, pathBase, pathArgs);
        }

        private boolean isBucketSpecified(Bucket bucket) {
            if (bucket == null) {
                return false;
            }
            return bucket.getName().length() != 0;
        }
    }
}

