/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.amazon.s3;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import net.noderunner.amazon.s3.Entry;
import net.noderunner.amazon.s3.ISO801DateFormat;
import net.noderunner.amazon.s3.Owner;
import net.noderunner.amazon.s3.Response;
import org.apache.commons.httpclient.HttpMethod;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListResponse
extends Response {
    private String name = null;
    private String prefix = null;
    private String marker = null;
    private String delimiter = null;
    private int maxKeys = 0;
    private boolean isTruncated = false;
    private String nextMarker = null;
    private List<Entry> entries = null;
    private List<CommonPrefixEntry> commonPrefixEntries = null;

    ListResponse(HttpMethod method) throws IOException {
        super(method);
        if (this.isOk()) {
            this.parse(new ListBucketHandler());
        }
    }

    public List<CommonPrefixEntry> getCommonPrefixEntries() {
        return this.commonPrefixEntries;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getMarker() {
        return this.marker;
    }

    public int getMaxKeys() {
        return this.maxKeys;
    }

    public boolean getIsTruncated() {
        return this.isTruncated;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    @Override
    public String toString() {
        return super.toString() + " entries=" + this.entries + " name=" + this.name + " prefix=" + this.prefix + " marker=" + this.marker + " maxKeys=" + this.maxKeys + " isTruncated=" + this.isTruncated + " nextMarker=" + this.nextMarker + " prefix=" + this.commonPrefixEntries;
    }

    class ListBucketHandler
    extends DefaultHandler {
        private boolean isEchoedPrefix = false;
        private Entry keyEntry = null;
        private CommonPrefixEntry commonPrefixEntry = null;
        private StringBuilder currText = null;
        private SimpleDateFormat iso8601Parser = null;

        public ListBucketHandler() {
            ListResponse.this.entries = new ArrayList();
            ListResponse.this.commonPrefixEntries = new ArrayList();
            this.iso8601Parser = new ISO801DateFormat();
            this.currText = new StringBuilder();
        }

        public void startDocument() {
            this.isEchoedPrefix = true;
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Contents")) {
                this.keyEntry = new Entry();
            } else if (name.equals("Owner")) {
                this.keyEntry.setOwner(new Owner());
            } else if (name.equals("CommonPrefixes")) {
                this.commonPrefixEntry = new CommonPrefixEntry();
            }
            this.currText = new StringBuilder();
        }

        public void endElement(String uri, String name, String qName) {
            if (name.equals("Name")) {
                ListResponse.this.name = this.currText.toString();
            } else if (name.equals("Prefix") && this.isEchoedPrefix) {
                ListResponse.this.prefix = this.currText.toString();
                this.isEchoedPrefix = false;
            } else if (name.equals("Marker")) {
                ListResponse.this.marker = this.currText.toString();
            } else if (name.equals("MaxKeys")) {
                ListResponse.this.maxKeys = Integer.parseInt(this.currText.toString());
            } else if (name.equals("Delimiter")) {
                ListResponse.this.delimiter = this.currText.toString();
            } else if (name.equals("IsTruncated")) {
                ListResponse.this.isTruncated = Boolean.valueOf(this.currText.toString());
            } else if (name.equals("NextMarker")) {
                ListResponse.this.nextMarker = this.currText.toString();
            } else if (name.equals("Contents")) {
                ListResponse.this.entries.add(this.keyEntry);
            } else if (name.equals("Key")) {
                this.keyEntry.setKey(this.currText.toString());
            } else if (name.equals("LastModified")) {
                try {
                    this.keyEntry.setLastModified(this.iso8601Parser.parse(this.currText.toString()));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Unexpected date format in list bucket output", e);
                }
            } else if (name.equals("ETag")) {
                this.keyEntry.setETag(this.currText.toString());
            } else if (name.equals("Size")) {
                this.keyEntry.setSize(Long.parseLong(this.currText.toString()));
            } else if (name.equals("StorageClass")) {
                this.keyEntry.setStorageClass(this.currText.toString());
            } else if (name.equals("ID")) {
                this.keyEntry.getOwner().setId(this.currText.toString());
            } else if (name.equals("DisplayName")) {
                this.keyEntry.getOwner().setDisplayName(this.currText.toString());
            } else if (name.equals("CommonPrefixes")) {
                ListResponse.this.commonPrefixEntries.add(this.commonPrefixEntry);
            } else if (name.equals("Prefix")) {
                this.commonPrefixEntry.prefix = this.currText.toString();
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public static class CommonPrefixEntry {
        private String prefix;

        CommonPrefixEntry() {
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

