/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.amazon.s3;

import java.io.IOException;
import java.io.InputStream;
import net.noderunner.amazon.s3.Headers;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Response {
    private HttpMethod method;

    Response(HttpMethod method) {
        this.method = method;
    }

    public int getResponseCode() throws IOException {
        return this.method.getStatusCode();
    }

    public String getResponseMessage() throws IOException {
        return this.method.getStatusText();
    }

    public int getContentLength() {
        return -1;
    }

    public void assertOk() {
        String msg;
        if (this.isOk()) {
            return;
        }
        try {
            msg = this.method.getResponseBodyAsString();
        }
        catch (IOException e) {
            msg = "?";
        }
        throw new IllegalStateException("Unexpected response: " + this + " Message: " + msg);
    }

    public String getHeaderField(String field) {
        Header header = this.method.getResponseHeader(field);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public Headers getHeaders() {
        return new Headers(this.method.getResponseHeaders());
    }

    public boolean isOk() {
        try {
            int code = this.getResponseCode();
            return code == 200 || code == 204;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isNotFound() {
        try {
            return this.getResponseCode() == 404;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String toString() {
        try {
            return "Response code=" + this.getResponseCode() + " msg='" + this.getResponseMessage() + "'";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void parse(ContentHandler handler) throws IOException {
        try {
            XMLReader xr = Response.createXMLReader();
            xr.setContentHandler(handler);
            ErrorHandler eh = new ErrorHandler(){

                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }

                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }

                public void warning(SAXParseException e) throws SAXException {
                    throw e;
                }
            };
            xr.setErrorHandler(eh);
            InputStream is = this.method.getResponseBodyAsStream();
            xr.parse(new InputSource(is));
            is.close();
        }
        catch (SAXException e) {
            throw new RuntimeException("Unexpected error parsing ListBucket xml", e);
        }
    }

    static XMLReader createXMLReader() {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
            try {
                return XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e2) {
                throw new RuntimeException("Couldn't initialize a sax driver for the XMLReader");
            }
        }
    }
}

