package net.nowtryz.cafetapi.datas;

import java.io.IOException;
import java.util.Calendar;

import net.nowtryz.cafetapi.CafetAPI;
import net.nowtryz.cafetapi.exceptions.APIException;

/**
 * @author Damien
 * @since 1.0
 */
public class Reload extends CafetData {
	private int id;
	private int client;
	private String details;
	private Calendar date;
	private float amount;
	private float balanceAfterTransaction;
	
	/**
	 * The Reloas object is the one that stores reload information for
	 * later use, it's generaly generated by the Client's method
	 * {@link Client#getReloads() getReloads} or even directly whith the Data
	 * static method {@link CafetAPI#getClientReloads(int) getClientReloads()}.
	 * 
	 * @param id
	 * @param client
	 * @param date
	 * @param amount
	 * @param balanceAfterTransaction
	 * @since 1.0
	 */
	public Reload(int id, int client, String details, Calendar date, float amount, float balanceAfterTransaction) {
		this.id = id;
		this.client = client;
		this.details = details;
		this.date = date;
		this.amount = amount;
		this.balanceAfterTransaction = balanceAfterTransaction;
	}
	/**
	 * The Reloas object is the one that stores reload information for
	 * later use, it's generaly generated by the Client's method
	 * {@link Client#getReloads() getReloads} or even directly whith the Data
	 * static method {@link CafetAPI#getClientReloads(int) getClientReloads()}.
	 * 
	 * @since 1.0
	 */
	public Reload() {
		this.id = 0;
		this.client = 0;
		this.details = "";
		this.date = Calendar.getInstance();
		this.amount = 0.0f;
		this.balanceAfterTransaction = 0.0f;
	}
	/**
	 * Return the id
	 * @return the id
	 * @since 1.0
	 */
	public final int getId() {
		return id;
	}
	/**
	 * Return the client
	 * @return the client
	 * @throws IOException 
	 * @throws APIException 
	 * @since 1.0
	 */
	public final Client getClient() throws APIException, IOException {
		return CafetAPI.getInstance().getClient(client).getData();
	}
	/**
	 * Return the details
	 * @return the details
	 * @since 1.0
	 */
	public final String getDetails() {
		return details;
	}
	/**
	 * Return the date
	 * @return the date
	 * @since 1.0
	 */
	public final Calendar getDate() {
		return date;
	}
	/**
	 * Return the amount
	 * @return the amount
	 * @since 1.0
	 */
	public final float getAmount() {
		return amount;
	}
	/**
	 * Return the balanceAfterTransaction
	 * @return the balanceAfterTransaction
	 * @since 1.0
	 */
	public final float getBalanceAfterTransaction() {
		return balanceAfterTransaction;
	}
}
