/*
 * Decompiled with CFR 0.152.
 */
package net.nowtryz.cafetapi;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.nowtryz.cafetapi.AsyncHandler;
import net.nowtryz.cafetapi.Ordered;
import net.nowtryz.cafetapi.ServerExceptionsManager;
import net.nowtryz.cafetapi.datas.Choice;
import net.nowtryz.cafetapi.datas.Client;
import net.nowtryz.cafetapi.datas.Expense;
import net.nowtryz.cafetapi.datas.ExpenseDetail;
import net.nowtryz.cafetapi.datas.Formula;
import net.nowtryz.cafetapi.datas.FormulaBought;
import net.nowtryz.cafetapi.datas.OrderBuilder;
import net.nowtryz.cafetapi.datas.Product;
import net.nowtryz.cafetapi.datas.ProductBought;
import net.nowtryz.cafetapi.datas.ProductGroup;
import net.nowtryz.cafetapi.datas.Reload;
import net.nowtryz.cafetapi.exceptions.APIException;
import net.nowtryz.cafetapi.exceptions.HTTPException;
import net.nowtryz.cafetapi.exceptions.PermissionException;
import net.nowtryz.cafetapi.exceptions.QueryException;
import net.nowtryz.cafetapi.exceptions.ServerErrorException;
import net.nowtryz.cafetapi.http.HttpManager;
import net.nowtryz.cafetapi.parsers.ArrayParser;
import net.nowtryz.cafetapi.parsers.DataParser;
import net.nowtryz.cafetapi.parsers.DefaultParser;
import net.nowtryz.cafetapi.parsers.LoginParser;
import net.nowtryz.cafetapi.results.ArrayResult;
import net.nowtryz.cafetapi.results.DataResult;
import net.nowtryz.cafetapi.results.LoginResult;
import net.nowtryz.cafetapi.results.Result;
import net.nowtryz.cafetapi.user.User;
import net.nowtryz.cafetapi.utils.Base64Coder;

public class CafetAPI {
    private static final String SERVER_API_VERSION = "1.0.0-alpha";
    private static final String THREAD_NAME = "async-api-";
    private static CafetAPI instance;
    private static int asyncThreads;
    public static final String NAME;
    public static final String VERSION;
    public static final String BUILD;
    public static final String RELEASE_DATE;
    private HttpManager manager;
    private String serverVersion;
    private User user;

    public static String getVersion() {
        return SERVER_API_VERSION;
    }

    public static CafetAPI getInstance() {
        return instance;
    }

    public static synchronized void setInstance(CafetAPI instance) {
        CafetAPI.instance = instance;
    }

    public CafetAPI(URL url) {
        this.manager = HttpManager.newInstance(url);
        CafetAPI.setInstance(this);
    }

    public final String getServerVersion() {
        return this.serverVersion;
    }

    public final User getUser() {
        return this.user;
    }

    public final URL getUrl() {
        return this.manager.getUrl();
    }

    public final void setUrl(URL url) {
        this.manager.setUrl(url);
    }

    private final QueryException checkPermissionException(ServerErrorException e) {
        if (e.getResult().getErrorCode().equals("02-003")) {
            return new PermissionException(e);
        }
        return e;
    }

    public LoginResult login(String email, String password) throws IOException, APIException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String endodedBasicAuth = Base64.getEncoder().encodeToString(new String(email + ":" + password).getBytes());
        headers.put("Authorization", "Basic " + endodedBasicAuth);
        try {
            LoginResult result = LoginParser.parseResponse(this.manager.query(HttpManager.HttpMethod.POST, "user/login", null, headers));
            this.manager.setSessionId(result.getSessionId());
            this.user = result.getUser();
            return result;
        }
        catch (HTTPException e) {
            throw ServerExceptionsManager.handle(e);
        }
    }

    public void asyncLogin(final AsyncHandler.AsyncLoginHandler handler, final String email, final String password) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.login(email, password));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, "login-" + asyncThreads++).start();
    }

    public ArrayResult<Client> getClients() throws APIException, IOException {
        try {
            return ArrayParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/clients"), Client.class, Client[].class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetClients(final AsyncHandler.AsyncArrayHandler<Client> handler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getClients());
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public DataResult<Client> getClient(int id) throws APIException, IOException {
        try {
            return DataParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/clients/" + id), Client.class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetClient(final AsyncHandler.AsyncDataHandler<Client> handler, final int id) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getClient(id));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public ArrayResult<Reload> getClientReloads(int id) throws APIException, IOException {
        try {
            return ArrayParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/clients/" + id + "/reloads"), Reload.class, Reload[].class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetClientReloads(final AsyncHandler.AsyncArrayHandler<Reload> handler, final int id) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getClientReloads(id));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public ArrayResult<Expense> getClientExpenses(int id) throws APIException, IOException {
        try {
            return ArrayParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/clients/" + id + "/expenses"), Expense.class, Expense[].class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetClientExpenses(final AsyncHandler.AsyncArrayHandler<Expense> handler, final int id) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getClientExpenses(id));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public ArrayResult<ExpenseDetail> getExpenseDetails(int id) throws APIException, IOException {
        try {
            return ArrayParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/expenses/" + id + "/details"), ExpenseDetail.class, ExpenseDetail[].class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetExpenseDetails(final AsyncHandler.AsyncArrayHandler<ExpenseDetail> handler, final int id) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getExpenseDetails(id));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public DataResult<ProductBought> getProductBought(int id) throws APIException, IOException {
        try {
            return DataParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/products_bought/" + id), ProductBought.class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetProductBought(final AsyncHandler.AsyncDataHandler<ProductBought> handler, final int id) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getProductBought(id));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public DataResult<FormulaBought> getFormulaBought(int id) throws APIException, IOException {
        try {
            return DataParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/formulas_bought/" + id), FormulaBought.class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetFormulaBought(final AsyncHandler.AsyncDataHandler<FormulaBought> handler, final int id) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getFormulaBought(id));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public ArrayResult<ProductGroup> getProductGroups() throws APIException, IOException {
        try {
            return ArrayParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/groups"), ProductGroup.class, ProductGroup[].class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetProductGroups(final AsyncHandler.AsyncArrayHandler<ProductGroup> handler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getProductGroups());
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public DataResult<ProductGroup> getProductGroup(int id) throws APIException, IOException {
        try {
            return DataParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/formulas_bought/" + id), ProductGroup.class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetProductGroup(final AsyncHandler.AsyncDataHandler<ProductGroup> handler, final int id) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getProductGroup(id));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public ArrayResult<Product> getGroupProducts(int id, boolean showUnviewable) throws APIException, IOException {
        try {
            return ArrayParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/groups/" + id + "/products" + (showUnviewable ? "?hidden" : "")), Product.class, Product[].class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetGroupProducts(final AsyncHandler.AsyncArrayHandler<Product> handler, final int id, final boolean showUnviewable) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getGroupProducts(id, showUnviewable));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public ArrayResult<ProductBought> getFormumaBoughtProducts(int id) throws APIException, IOException {
        try {
            return ArrayParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/formulas_bought/" + id + "/products"), ProductBought.class, ProductBought[].class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetFormumaBoughtProducts(final AsyncHandler.AsyncArrayHandler<ProductBought> handler, final int id) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getFormumaBoughtProducts(id));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public DataResult<Product> getProduct(int id) throws APIException, IOException {
        try {
            return DataParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/products/" + id), Product.class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetProduct(final AsyncHandler.AsyncDataHandler<Product> handler, final int id) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getProduct(id));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public ArrayResult<Formula> getFormulas(boolean showUnviewable) throws APIException, IOException {
        try {
            return ArrayParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/formulas" + (showUnviewable ? "?hidden" : "")), Formula.class, Formula[].class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetFormulas(final AsyncHandler.AsyncArrayHandler<Formula> handler, final boolean showUnviewable) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getFormulas(showUnviewable));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public DataResult<Formula> getFormula(int id) throws APIException, IOException {
        try {
            return DataParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/formulas/" + id), Formula.class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetFormula(final AsyncHandler.AsyncDataHandler<Formula> handler, final int id) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getFormula(id));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public ArrayResult<Choice> getFormulaChoices(int id) throws APIException, IOException {
        try {
            return ArrayParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/formulas/" + id + "/choices"), Choice.class, Choice[].class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetFormulaChoices(final AsyncHandler.AsyncArrayHandler<Choice> handler, final int id) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getFormulaChoices(id));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public DataResult<Choice> getChoice(int id) throws APIException, IOException {
        try {
            return DataParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/choices/" + id), Choice.class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncGetChoice(final AsyncHandler.AsyncDataHandler<Choice> handler, final int id) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.getChoice(id));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public ArrayResult<Client> searchClient(String expression) throws APIException, IOException {
        try {
            return ArrayParser.parseResponse(this.manager.query(HttpManager.HttpMethod.GET, "cafet/clients/search/" + expression), Client.class, Client[].class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSearchClient(final AsyncHandler.AsyncArrayHandler<Client> handler, final String expression) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.searchClient(expression));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public DataResult<ProductGroup> addProductGroup(String name) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("name", (JsonElement)new JsonPrimitive(name));
        try {
            return DataParser.parseResponse(this.manager.query(HttpManager.HttpMethod.POST, "cafet/groups", (JsonElement)body), ProductGroup.class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncAddProductGroup(final AsyncHandler.AsyncDataHandler<ProductGroup> handler, final String name) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.addProductGroup(name));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public DataResult<Product> addProduct(String name, int groupId) throws APIException, IOException {
        return this.addProduct(name, groupId, 0.0, true);
    }

    public DataResult<Product> addProduct(String name, int groupId, double price, boolean viewable) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("group", (JsonElement)new JsonPrimitive((Number)groupId));
        body.add("name", (JsonElement)new JsonPrimitive(name));
        body.add("price", (JsonElement)new JsonPrimitive((Number)price));
        body.add("viewable", (JsonElement)new JsonPrimitive(Boolean.valueOf(viewable)));
        try {
            return DataParser.parseResponse(this.manager.query(HttpManager.HttpMethod.POST, "cafet/products", (JsonElement)body), Product.class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncAddProduct(final AsyncHandler.AsyncDataHandler<Product> handler, final String name, final int groupId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.addProduct(name, groupId));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public DataResult<Formula> addFormula(String name) throws APIException, IOException {
        return this.addFormula(name, 0.0, true);
    }

    public DataResult<Formula> addFormula(String name, double price, boolean viewable) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("name", (JsonElement)new JsonPrimitive(name));
        body.add("price", (JsonElement)new JsonPrimitive((Number)price));
        body.add("viewable", (JsonElement)new JsonPrimitive(Boolean.valueOf(viewable)));
        try {
            return DataParser.parseResponse(this.manager.query(HttpManager.HttpMethod.POST, "cafet/formulas", (JsonElement)body), Formula.class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncAddFormula(final AsyncHandler.AsyncDataHandler<Formula> handler, final String name) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.addFormula(name));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public DataResult<Choice> addChoice(String name, int formulaId) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("name", (JsonElement)new JsonPrimitive(name));
        try {
            return DataParser.parseResponse(this.manager.query(HttpManager.HttpMethod.POST, "cafet/formulas/" + formulaId + "/choices", (JsonElement)body), Choice.class);
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncAddChoice(final AsyncHandler.AsyncDataHandler<Choice> handler, final String name, final int formulaId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.addChoice(name, formulaId));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result addProductToChoice(int choiceId, int ... productIds) throws APIException, IOException {
        JsonObject body = new JsonObject();
        JsonArray products = new JsonArray();
        body.add("add", (JsonElement)products);
        for (int product : productIds) {
            products.add((Number)product);
        }
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.PATCH, "cafet/choices/" + choiceId, (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncAddProductToChoice(final AsyncHandler.AsyncSuccessHandler handler, final int choiceId, final int productId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.addProductToChoice(choiceId, productId));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result setProductGroupDisplayName(int groupId, String displayName) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("displayName", (JsonElement)new JsonPrimitive(displayName));
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.PATCH, "cafet/groups/" + groupId, (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSetProductGroupDisplayName(final AsyncHandler.AsyncSuccessHandler handler, final int groupId, final String displayName) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.setProductGroupDisplayName(groupId, displayName));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result setProductGroupName(int groupId, String name) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("name", (JsonElement)new JsonPrimitive(name));
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.PATCH, "cafet/groups/" + groupId, (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSetProductGroupName(final AsyncHandler.AsyncSuccessHandler handler, final int groupId, final String name) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.setProductGroupName(groupId, name));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result setProductName(int productId, String name) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("name", (JsonElement)new JsonPrimitive(name));
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.PATCH, "cafet/products/" + productId, (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSetProductName(final AsyncHandler.AsyncSuccessHandler handler, final int productId, final String name) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.setProductName(productId, name));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result setProductPrice(int productId, float price) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("price", (JsonElement)new JsonPrimitive((Number)Float.valueOf(price)));
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.PATCH, "cafet/products/" + productId, (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSetProductPrice(final AsyncHandler.AsyncSuccessHandler handler, final int productId, final float price) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CafetAPI.this.setProductPrice(productId, price);
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result setProductGroup(int productId, int groupId) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("group", (JsonElement)new JsonPrimitive((Number)groupId));
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.PATCH, "cafet/products/" + productId, (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSetProductGroup(final AsyncHandler.AsyncSuccessHandler handler, final int productId, final int groupId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.setProductGroup(productId, groupId));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result setProductImage(int productId, Image image, String format) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("image", (JsonElement)new JsonPrimitive(Base64Coder.encodeImage(image, format)));
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.PATCH, "cafet/products/" + productId, (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSetProductImage(final AsyncHandler.AsyncSuccessHandler handler, final int productId, final Image image, final String format) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.setProductImage(productId, image, format));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result setProductVisibility(int productId, boolean visilility) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("viewable", (JsonElement)new JsonPrimitive(Boolean.valueOf(visilility)));
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.PATCH, "cafet/products/" + productId, (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSetProductVisibility(final AsyncHandler.AsyncSuccessHandler handler, final int productId, final boolean visilility) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.setProductVisibility(productId, visilility));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result setFormulaName(int formulaId, String name) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("name", (JsonElement)new JsonPrimitive(name));
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.PATCH, "cafet/formulas/" + formulaId, (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSetFormulaName(final AsyncHandler.AsyncSuccessHandler handler, final int formulaId, final String name) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.setFormulaName(formulaId, name));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result setFormulaPrice(int formulaId, float price) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("price", (JsonElement)new JsonPrimitive((Number)Float.valueOf(price)));
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.PATCH, "cafet/formulas/" + formulaId, (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSetFormulaPrice(final AsyncHandler.AsyncSuccessHandler handler, final int formulaId, final float price) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.setFormulaPrice(formulaId, price));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result setFormulaImage(int formulaId, Image image, String format) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("image", (JsonElement)new JsonPrimitive(Base64Coder.encodeImage(image, format)));
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.PATCH, "cafet/formulas/" + formulaId, (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSetFormulaImage(final AsyncHandler.AsyncSuccessHandler handler, final int formulaId, final Image image, final String format) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.setFormulaImage(formulaId, image, format));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result setFormulaVisibility(int formulaId, boolean visilility) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("viewable", (JsonElement)new JsonPrimitive(Boolean.valueOf(visilility)));
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.PATCH, "cafet/formulas/" + formulaId, (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSetFormulaVisibility(final AsyncHandler.AsyncSuccessHandler handler, final int formulaId, final boolean visilility) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.setFormulaVisibility(formulaId, visilility));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result setChoiceName(int choiceId, String name) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("name", (JsonElement)new JsonPrimitive(name));
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.PATCH, "cafet/choices/" + choiceId, (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSetChoiceName(final AsyncHandler.AsyncSuccessHandler handler, final int choiceId, final String name) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.setChoiceName(choiceId, name));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result removeProductFromChoice(int choiceId, int ... productIds) throws APIException, IOException {
        JsonObject body = new JsonObject();
        JsonArray products = new JsonArray();
        body.add("remove", (JsonElement)products);
        for (int product : productIds) {
            products.add((Number)product);
        }
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.PATCH, "cafet/choices/" + choiceId, (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncRemoveProductFromChoice(final AsyncHandler.AsyncSuccessHandler handler, final int choiceId, final int productId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.removeProductFromChoice(choiceId, productId));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result removeProduct(int productId) throws APIException, IOException {
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.DELETE, "cafet/products/" + productId));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncRemoveProduct(final AsyncHandler.AsyncSuccessHandler handler, final int productId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.removeProduct(productId));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result removeProductGroup(int groupId) throws APIException, IOException {
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.DELETE, "cafet/groups/" + groupId));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncRemoveProductGroup(final AsyncHandler.AsyncSuccessHandler handler, final int groupId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.removeProductGroup(groupId));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result removeFormula(int formulaId) throws APIException, IOException {
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.DELETE, "cafet/formulas/" + formulaId));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncRemoveFormula(final AsyncHandler.AsyncSuccessHandler handler, final int formulaId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.removeFormula(formulaId));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result removeFormulaChoice(int choiceId) throws APIException, IOException {
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.DELETE, "cafet/choices/" + choiceId));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncRemoveFormulaChoice(final AsyncHandler.AsyncSuccessHandler handler, final int choiceId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.removeFormulaChoice(choiceId));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result saveReload(int clientId, float amount) throws APIException, IOException {
        JsonObject body = new JsonObject();
        body.add("client_id", (JsonElement)new JsonPrimitive((Number)clientId));
        body.add("amount", (JsonElement)new JsonPrimitive((Number)Float.valueOf(amount)));
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.POST, "cafet/reloads", (JsonElement)body));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSaveReload(final AsyncHandler.AsyncSuccessHandler handler, final int clientId, final float amount) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.saveReload(clientId, amount));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    public Result saveOrder(int clientId, Map<Product, Integer> products, Map<OrderBuilder.FormulaBuilder, Product[]> formulas) throws APIException, IOException {
        Ordered[] order = new Ordered[products.size() + formulas.size()];
        int i = 0;
        for (Product p : products.keySet()) {
            order[i] = new Ordered.ProductOrdered(p, products.get(p));
            ++i;
        }
        for (OrderBuilder.FormulaBuilder b : formulas.keySet()) {
            order[i] = new Ordered.FormulaOrdered(b.getFormula(), 1, formulas.get(b));
            ++i;
        }
        try {
            return DefaultParser.parseResponse(this.manager.query(HttpManager.HttpMethod.POST, "cafet/clients/" + clientId + "/order", new Gson().toJsonTree((Object)order)));
        }
        catch (ServerErrorException e) {
            throw this.checkPermissionException(e);
        }
    }

    public void asyncSaveOrder(final AsyncHandler.AsyncSuccessHandler handler, final int clientId, final Map<Product, Integer> products, final Map<OrderBuilder.FormulaBuilder, Product[]> formulas) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResult(CafetAPI.this.saveOrder(clientId, products, formulas));
                }
                catch (APIException e) {
                    handler.handleException(e);
                }
                catch (IOException e) {
                    handler.handleException(e);
                }
            }
        }, THREAD_NAME + asyncThreads++).start();
    }

    static {
        asyncThreads = 1;
        Properties properties = new Properties();
        try (InputStream is = CafetAPI.class.getResourceAsStream("api.properties");
             BufferedInputStream bis = new BufferedInputStream(is);){
            properties.load(bis);
        }
        catch (Exception exception) {
            // empty catch block
        }
        NAME = properties.getProperty("name");
        VERSION = properties.getProperty("version");
        BUILD = properties.getProperty("build");
        RELEASE_DATE = properties.getProperty("release.date");
    }
}

