/*
 * Decompiled with CFR 0.152.
 */
package net.nowtryz.cafetapi.datas;

import java.io.IOException;
import java.util.Arrays;
import net.nowtryz.cafetapi.CafetAPI;
import net.nowtryz.cafetapi.datas.CafetData;
import net.nowtryz.cafetapi.datas.Formula;
import net.nowtryz.cafetapi.datas.Product;
import net.nowtryz.cafetapi.exceptions.APIException;
import net.nowtryz.cafetapi.utils.Lang;

public class Choice
extends CafetData {
    private int id;
    private String name;
    private Product[] choice;
    private int formula;

    public Choice() {
        this.id = 0;
        this.name = Lang.get("Unknown");
        this.choice = new Product[0];
        this.formula = 0;
    }

    public Choice(int id, String name, int formulaId, Product[] choice) {
        this.id = id;
        this.name = name;
        this.choice = choice;
        this.formula = formulaId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Formula getFormula() throws APIException, IOException {
        return CafetAPI.getInstance().getFormula(this.formula).getData();
    }

    public Product[] getProducts() {
        return this.choice;
    }

    public void addProduct(Product product) throws APIException, IOException {
        CafetAPI.getInstance().addProductToChoice(this.id, product.getId());
    }

    public void remove(Product product) throws APIException, IOException {
        CafetAPI.getInstance().removeProductFromChoice(this.id, product.getId());
    }

    public void setName(String name) throws APIException, IOException {
        CafetAPI.getInstance().setChoiceName(this.id, name);
        this.name = name;
    }

    public void delete() throws APIException, IOException {
        CafetAPI.getInstance().removeFormulaChoice(this.id);
        this.id = 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.choice);
        result = 31 * result + this.formula;
        result = 31 * result + this.id;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Choice other = (Choice)obj;
        if (!Arrays.equals(this.choice, other.choice)) {
            return false;
        }
        if (this.formula != other.formula) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

