/*
 * Decompiled with CFR 0.152.
 */
package net.nowtryz.cafetapi.datas;

import java.io.IOException;
import java.util.Calendar;
import net.nowtryz.cafetapi.CafetAPI;
import net.nowtryz.cafetapi.datas.CafetData;
import net.nowtryz.cafetapi.datas.Expense;
import net.nowtryz.cafetapi.datas.Reload;
import net.nowtryz.cafetapi.exceptions.APIException;
import net.nowtryz.cafetapi.utils.Lang;
import net.nowtryz.cafetapi.utils.WordUtils;

public class Client
extends CafetData {
    private int id;
    private String email;
    private String alias;
    private String familyName;
    private String firstname;
    private boolean member;
    private float balance;
    private int registrationYear;

    public Client(int id, String email, String alias, String familyNane, String surname, boolean member, float balance, int registrationYear) {
        this.id = id;
        this.email = email;
        this.alias = alias;
        this.familyName = familyNane;
        this.firstname = surname;
        this.member = member;
        this.balance = balance;
        this.registrationYear = registrationYear;
    }

    public Client() {
        this.id = 0;
        this.email = Lang.get("Unknown");
        this.alias = Lang.get("Unknown");
        this.familyName = Lang.get("Unknown");
        this.firstname = Lang.get("Unknown");
        this.member = false;
        this.balance = 0.0f;
        this.registrationYear = Calendar.getInstance().get(1);
    }

    public final int getId() {
        return this.id;
    }

    public final String getEmail() {
        return this.email;
    }

    public final String getAlias() {
        return this.alias;
    }

    public final String getFamilyNane() {
        return this.familyName;
    }

    public final String getSurname() {
        return this.firstname;
    }

    public final boolean isMember() {
        return this.member;
    }

    public final float getBalance() {
        return this.balance;
    }

    public final int getRegistrationYear() {
        return this.registrationYear;
    }

    public final Expense[] getExpenses() throws APIException, IOException {
        return (Expense[])CafetAPI.getInstance().getClientExpenses(this.id).getDatas();
    }

    public final Reload[] getReloads() throws APIException, IOException {
        return (Reload[])CafetAPI.getInstance().getClientReloads(this.id).getDatas();
    }

    public final String getFormatedName() {
        return WordUtils.capitalizeFirstLetter(this.getSurname()) + " " + this.getFamilyNane().toUpperCase();
    }

    public String toString() {
        return WordUtils.capitalizeFirstLetter(this.getSurname()) + " " + this.getFamilyNane().toUpperCase();
    }

    public void update() throws APIException, IOException {
        Client c = CafetAPI.getInstance().getClient(this.id).getData();
        this.id = c.id;
        this.email = c.email;
        this.alias = c.alias;
        this.familyName = c.familyName;
        this.firstname = c.firstname;
        this.member = c.member;
        this.balance = c.balance;
        this.registrationYear = c.registrationYear;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        long temp = Double.doubleToLongBits(this.balance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.familyName == null ? 0 : this.familyName.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (this.member ? 1231 : 1237);
        result = 31 * result + this.registrationYear;
        result = 31 * result + (this.firstname == null ? 0 : this.firstname.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Client)) {
            return false;
        }
        Client other = (Client)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        if (Double.doubleToLongBits(this.balance) != Double.doubleToLongBits(other.balance)) {
            return false;
        }
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.familyName == null ? other.familyName != null : !this.familyName.equals(other.familyName)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.member != other.member) {
            return false;
        }
        if (this.registrationYear != other.registrationYear) {
            return false;
        }
        return !(this.firstname == null ? other.firstname != null : !this.firstname.equals(other.firstname));
    }
}

