/*
 * Decompiled with CFR 0.152.
 */
package net.nowtryz.cafetapi.datas;

import java.io.IOException;
import java.util.Calendar;
import net.nowtryz.cafetapi.CafetAPI;
import net.nowtryz.cafetapi.datas.CafetData;
import net.nowtryz.cafetapi.datas.Client;
import net.nowtryz.cafetapi.datas.ExpenseDetail;
import net.nowtryz.cafetapi.exceptions.APIException;

public class Expense
extends CafetData {
    private int id;
    private int client;
    private Calendar date;
    private float total;
    private float balanceAfterTransaction;

    public Expense(int id, int client, Calendar date, float total, float balanceAfterTransaction) {
        this.id = id;
        this.client = client;
        this.date = date;
        this.total = total;
        this.balanceAfterTransaction = balanceAfterTransaction;
    }

    public Expense() {
        this.id = 0;
        this.client = 0;
        this.date = Calendar.getInstance();
        this.total = 0.0f;
        this.balanceAfterTransaction = 0.0f;
    }

    public final int getId() {
        return this.id;
    }

    public final Client getClient() throws APIException, IOException {
        return CafetAPI.getInstance().getClient(this.client).getData();
    }

    public final Calendar getDate() {
        return this.date;
    }

    public final double getTotal() {
        return this.total;
    }

    public final float getBalanceAfterTransaction() {
        return this.balanceAfterTransaction;
    }

    public final ExpenseDetail[] getDetails() throws APIException, IOException {
        return (ExpenseDetail[])CafetAPI.getInstance().getExpenseDetails(this.id).getDatas();
    }

    public String toString() {
        return "Expense [id=" + this.id + ", client=" + this.client + ", date=" + this.date + ", total=" + this.total + ", balanceAfterTransaction=" + this.balanceAfterTransaction + "]";
    }
}

