/*
 * Decompiled with CFR 0.152.
 */
package net.nowtryz.cafetapi.datas;

import java.io.IOException;
import java.util.Calendar;
import net.nowtryz.cafetapi.CafetAPI;
import net.nowtryz.cafetapi.datas.CafetData;
import net.nowtryz.cafetapi.datas.Client;
import net.nowtryz.cafetapi.exceptions.APIException;
import net.nowtryz.cafetapi.utils.Lang;

public abstract class ExpenseDetail
extends CafetData {
    protected String name;
    protected int client;
    protected float price;
    protected int quantity;
    protected Calendar date;

    public ExpenseDetail(String name, int client, float price, int quantity, Calendar date) {
        this.name = name;
        this.client = client;
        this.price = price;
        this.quantity = quantity;
        this.date = date;
    }

    public ExpenseDetail() {
        this.name = Lang.get("Unknown");
        this.client = 0;
        this.price = 0.0f;
        this.quantity = 0;
        this.date = Calendar.getInstance();
    }

    public final String getName() {
        return this.name;
    }

    public final Client getClient() throws APIException, IOException {
        return CafetAPI.getInstance().getClient(this.client).getData();
    }

    public final float getPrice() {
        return this.price;
    }

    public final int getQuantity() {
        return this.quantity;
    }

    public final Calendar getDate() {
        return this.date;
    }
}

