/*
 * Decompiled with CFR 0.152.
 */
package net.nowtryz.cafetapi.datas;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import net.nowtryz.cafetapi.CafetAPI;
import net.nowtryz.cafetapi.datas.Choice;
import net.nowtryz.cafetapi.datas.Formula;
import net.nowtryz.cafetapi.datas.Product;
import net.nowtryz.cafetapi.exceptions.APIException;

public class OrderBuilder {
    private HashMap<Product, Integer> orderProducts = new HashMap();
    private HashMap<FormulaBuilder, Product[]> orderFormula = new HashMap();

    public int orderProduct(Product product) {
        if (!this.orderProducts.containsKey(product)) {
            this.orderProducts.put(product, 0);
        }
        int count = this.orderProducts.get(product);
        this.orderProducts.put(product, ++count);
        return count;
    }

    public int removeProduct(Product product) {
        return this.orderProducts.remove(product);
    }

    public FormulaBuilder buildFormula(Formula formula) throws APIException, IOException {
        return new FormulaBuilder(formula);
    }

    public void save(CafetAPI api, int clientId) throws APIException, IOException {
        api.saveOrder(clientId, this.orderProducts, this.orderFormula);
    }

    public class FormulaBuilder {
        private Formula formula;
        private Choice[] choices;
        private HashMap<Choice, Product> products = new HashMap();

        private FormulaBuilder(Formula formula) throws APIException, IOException {
            this.formula = formula;
            this.choices = formula.getChoices();
        }

        public Formula getFormula() {
            return this.formula;
        }

        public Choice[] getChoices() {
            return this.choices;
        }

        public FormulaBuilder setChoice(Choice choice, Product product) {
            if (!Arrays.asList(this.choices).contains(choice)) {
                throw new IllegalArgumentException("this builder does not contain the given choice");
            }
            if (this.products.containsKey(choice)) {
                this.products.replace(choice, this.products.get(choice), product);
            } else {
                this.products.put(choice, product);
            }
            return this;
        }

        public Product[] getOrder() {
            return this.products.values().toArray(new Product[this.products.size()]);
        }

        public void build() {
            OrderBuilder.this.orderFormula.put(this, this.getOrder());
        }
    }
}

