/*
 * Decompiled with CFR 0.152.
 */
package net.nowtryz.cafetapi.datas;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Calendar;
import net.nowtryz.cafetapi.datas.CafetData;
import net.nowtryz.cafetapi.exceptions.APIException;
import net.nowtryz.cafetapi.utils.Lang;

public abstract class Payable
extends CafetData {
    protected int id;
    protected String name;
    protected Image image;
    protected float price;
    protected boolean viewable;
    protected Calendar edit;

    Payable(int id, String name, Image image, float price, boolean viewable, Calendar edit) {
        this.id = id;
        this.image = image;
        this.name = name;
        this.price = price;
        this.viewable = viewable;
        this.edit = edit;
    }

    Payable() {
        this.id = 0;
        this.image = new BufferedImage(20, 20, 3);
        this.name = Lang.get("Unknown");
        this.price = 0.0f;
        this.viewable = false;
        this.edit = Calendar.getInstance();
    }

    public final int getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final Image getImage() {
        return this.image;
    }

    public final float getPrice() {
        return this.price;
    }

    public final boolean isViewable() {
        return this.viewable;
    }

    public final Calendar getEdit() {
        return this.edit;
    }

    public final void setId() {
    }

    public abstract void setImage(Image var1, String var2) throws APIException, IOException;

    public abstract void setName(String var1) throws APIException, IOException;

    public abstract void setPrice(float var1) throws APIException, IOException;

    public abstract void setViewable(boolean var1) throws APIException, IOException;

    public abstract void delete() throws APIException, IOException;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.edit == null ? 0 : this.edit.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (this.image == null ? 0 : this.image.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Float.floatToIntBits(this.price);
        result = 31 * result + (this.viewable ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Payable other = (Payable)obj;
        if (this.edit == null ? other.edit != null : !this.edit.equals(other.edit)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.image == null && other.image != null) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (Float.floatToIntBits(this.price) != Float.floatToIntBits(other.price)) {
            return false;
        }
        return this.viewable == other.viewable;
    }
}

