/*
 * Decompiled with CFR 0.152.
 */
package net.nowtryz.cafetapi.datas;

import java.awt.Image;
import java.io.IOException;
import java.util.Calendar;
import net.nowtryz.cafetapi.CafetAPI;
import net.nowtryz.cafetapi.datas.Payable;
import net.nowtryz.cafetapi.datas.ProductGroup;
import net.nowtryz.cafetapi.exceptions.APIException;

public class Product
extends Payable {
    private int group;

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.group;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Product other = (Product)obj;
        return this.group == other.group;
    }

    public Product(int id, String name, float price, int group, Image image, boolean viewable, Calendar edit) {
        super(id, name, image, price, viewable, edit);
        this.group = group;
    }

    public Product() {
    }

    public final ProductGroup getGroup() throws APIException, IOException {
        return CafetAPI.getInstance().getProductGroup(this.group).getData();
    }

    public final void setGroup(ProductGroup group) throws APIException, IOException {
        CafetAPI.getInstance().setProductGroup(this.id, group.getId());
        this.group = group.getId();
    }

    @Override
    public final void setImage(Image image, String format) throws IOException, APIException {
        CafetAPI.getInstance().setProductImage(this.id, image, format);
        this.image = image;
    }

    @Override
    public final void setName(String name) throws APIException, IOException {
        CafetAPI.getInstance().setProductName(this.id, name);
        this.name = name;
    }

    @Override
    public final void setPrice(float price) throws APIException, IOException {
        CafetAPI.getInstance().setProductPrice(this.id, price);
        this.price = price;
    }

    @Override
    public final void setViewable(boolean viewable) throws APIException, IOException {
        CafetAPI.getInstance().setProductVisibility(this.id, viewable);
        this.viewable = viewable;
    }

    @Override
    public final void delete() throws APIException, IOException {
        CafetAPI.getInstance().removeProduct(this.id);
        this.id = 0;
    }

    public String toString() {
        return this.name;
    }
}

