/*
 * Decompiled with CFR 0.152.
 */
package net.nowtryz.cafetapi.http;

import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import net.nowtryz.cafetapi.CafetAPI;
import net.nowtryz.cafetapi.exceptions.ContentTypeException;
import net.nowtryz.cafetapi.exceptions.HTTPException;
import net.nowtryz.cafetapi.exceptions.QueryException;
import net.nowtryz.cafetapi.http.HTTPResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class HttpManager {
    private static final String USER_AGENT = "CafetAPI/" + CafetAPI.VERSION;
    private static final String PATH_PREFIX = "api/v1/";
    private static final String ENCODING = "UTF-8";
    private static final String MIME_TYPE = "application/json";
    private static final String SERVER_MIME_TYPE = "application/json; charset=UTF-8";
    private static HttpManager instance;
    private URL url;
    private String sessionId;

    public static HttpManager newInstance(URL url) {
        instance = new HttpManager(url);
        return instance;
    }

    public static HttpManager getInstance() {
        return instance;
    }

    private HttpManager(URL url) {
        this.url = url;
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    public final void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public final URL getUrl() {
        return this.url;
    }

    public final void setUrl(URL url) {
        this.url = url;
    }

    public HTTPResponse query(HttpMethod method, String path, JsonElement body) throws IOException, QueryException {
        return this.query(method, path, body, null);
    }

    public HTTPResponse query(HttpMethod method, String path) throws IOException, QueryException {
        return this.query(method, path, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPResponse query(HttpMethod method, String path, JsonElement body, Map<String, String> headers) throws IOException, QueryException {
        HTTPResponse response;
        block41: {
            CloseableHttpResponse httpResponse;
            HttpEntity entity;
            HttpGet httpRequest;
            URL resourceUrl = new URL(this.url, PATH_PREFIX + path);
            StringBuilder responseBuilder = new StringBuilder();
            CloseableHttpClient httpclient = HttpClients.createSystem();
            switch (method) {
                case DELETE: {
                    httpRequest = new HttpDelete(resourceUrl.toString());
                    break;
                }
                case GET: {
                    httpRequest = new HttpGet(resourceUrl.toString());
                    break;
                }
                case HEAD: {
                    httpRequest = new HttpHead(resourceUrl.toString());
                    break;
                }
                case PATCH: {
                    httpRequest = this.fillEntity((HttpEntityEnclosingRequestBase)new HttpPatch(resourceUrl.toString()), body);
                    break;
                }
                case POST: {
                    httpRequest = this.fillEntity((HttpEntityEnclosingRequestBase)new HttpPost(resourceUrl.toString()), body);
                    break;
                }
                case PUT: {
                    httpRequest = this.fillEntity((HttpEntityEnclosingRequestBase)new HttpPut(resourceUrl.toString()), body);
                    break;
                }
                default: {
                    httpRequest = new HttpGet();
                }
            }
            httpRequest.addHeader("User-Agent", USER_AGENT);
            httpRequest.addHeader("Accept", MIME_TYPE);
            httpRequest.addHeader("Content-Type", MIME_TYPE);
            if (this.sessionId != null) {
                httpRequest.addHeader("Session", this.sessionId);
            }
            if (headers != null) {
                headers.forEach((arg_0, arg_1) -> HttpManager.lambda$query$0((HttpRequestBase)httpRequest, arg_0, arg_1));
            }
            if ((entity = (httpResponse = httpclient.execute((HttpUriRequest)httpRequest)).getEntity()) != null) {
                entity = new BufferedHttpEntity(entity);
                try (InputStreamReader isr = new InputStreamReader(entity.getContent(), ENCODING);
                     BufferedReader in = new BufferedReader(isr);){
                    int c;
                    while ((c = in.read()) >= 0) {
                        responseBuilder.append((char)c);
                    }
                    String responseBody = responseBuilder.toString();
                    response = new HTTPResponse(responseBody, entity.getContentType().getValue(), httpResponse.getStatusLine().getStatusCode(), httpResponse.getStatusLine().getReasonPhrase(), entity.getContentLength(), httpResponse.getAllHeaders());
                    if (entity.getContentLength() > 0L && !SERVER_MIME_TYPE.equalsIgnoreCase(entity.getContentType().getValue())) {
                        throw new ContentTypeException("Got " + entity.getContentType().getValue() + " while expecting " + SERVER_MIME_TYPE, response);
                    }
                    break block41;
                }
                finally {
                    entity.getContent().close();
                    httpResponse.close();
                    httpclient.close();
                }
            }
            response = new HTTPResponse(null, null, httpResponse.getStatusLine().getStatusCode(), httpResponse.getStatusLine().getReasonPhrase(), 0L, httpResponse.getAllHeaders());
        }
        if (response.getCode() / 100 > 3) {
            throw new HTTPException("The server responded whith an " + response.getCode() + " " + response.getMessage() + " error code", response.getCode(), response);
        }
        return response;
    }

    private HttpEntityEnclosingRequestBase fillEntity(HttpEntityEnclosingRequestBase request, JsonElement body) {
        if (body != null) {
            request.setEntity((HttpEntity)new StringEntity(body.toString(), ContentType.APPLICATION_JSON));
        }
        return request;
    }

    private static /* synthetic */ void lambda$query$0(HttpRequestBase httpRequest, String name, String value) {
        httpRequest.addHeader(name, value);
    }

    public static enum HttpMethod {
        DELETE,
        GET,
        HEAD,
        POST,
        PUT,
        PATCH;

    }
}

