/*
 * Decompiled with CFR 0.152.
 */
package net.nowtryz.cafetapi.parsers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Array;
import java.util.Iterator;
import net.nowtryz.cafetapi.datas.CafetData;
import net.nowtryz.cafetapi.exceptions.IllegalResultException;
import net.nowtryz.cafetapi.exceptions.MissingResultElementException;
import net.nowtryz.cafetapi.http.HTTPResponse;
import net.nowtryz.cafetapi.parsers.AbstractParser;
import net.nowtryz.cafetapi.results.ArrayResult;
import net.nowtryz.cafetapi.results.Status;

public class ArrayParser<T extends CafetData>
extends AbstractParser<ArrayResult<T>> {
    private Class<T> classOfT;
    private Class<T[]> classOfTArray;

    public ArrayParser(Class<T> classOfT, Class<T[]> classOfTArray) {
        this.classOfT = classOfT;
        this.classOfTArray = classOfTArray;
    }

    public static <T> T[] newArray(Class<T[]> type, int size) {
        return type.cast(Array.newInstance(type.getComponentType(), size));
    }

    @Override
    public ArrayResult<T> parse(HTTPResponse response) throws MissingResultElementException, IllegalResultException {
        JsonElement json = this.parseJson(response.getResponse());
        if (!json.isJsonArray()) {
            throw new IllegalResultException("Unable to read the result : the result isn't an array");
        }
        JsonArray array = json.getAsJsonArray();
        CafetData[] resultArray = (CafetData[])ArrayParser.newArray(this.classOfTArray, array.size());
        if (array.size() > 0) {
            String type = array.get(0).getAsJsonObject().get("type").getAsString();
            Iterator iterator = array.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                JsonObject o = ((JsonElement)iterator.next()).getAsJsonObject();
                if (!(o.has("type") && o.get("type").isJsonPrimitive() && o.getAsJsonPrimitive("type").isString())) {
                    throw new IllegalResultException("Expected type to be a string");
                }
                if (!o.getAsJsonPrimitive("type").getAsString().equals(type)) {
                    throw new IllegalResultException("Type mismatche between objects of the same array");
                }
                resultArray[i] = (CafetData)this.getClassDecoder().fromJson((JsonElement)o, this.classOfT);
                ++i;
            }
        }
        return new ArrayResult(Status.OK, this.getComputing(response), resultArray);
    }

    public static <T extends CafetData> ArrayResult<T> parseResponse(HTTPResponse response, Class<T> classOfT, Class<T[]> classOfTArray) throws MissingResultElementException, IllegalResultException {
        return new ArrayParser<T>(classOfT, classOfTArray).parse(response);
    }
}

