/*
 * Decompiled with CFR 0.152.
 */
package net.nowtryz.cafetapi.parsers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.nowtryz.cafetapi.datas.CafetData;
import net.nowtryz.cafetapi.exceptions.IllegalResultException;
import net.nowtryz.cafetapi.exceptions.MissingResultElementException;
import net.nowtryz.cafetapi.http.HTTPResponse;
import net.nowtryz.cafetapi.parsers.AbstractParser;
import net.nowtryz.cafetapi.results.DataResult;
import net.nowtryz.cafetapi.results.Status;

public class DataParser<S extends CafetData>
extends AbstractParser<DataResult<S>> {
    private Class<S> classOfS;

    public DataParser(Class<S> classOfS) {
        this.classOfS = classOfS;
    }

    @Override
    public DataResult<S> parse(HTTPResponse response) throws MissingResultElementException, IllegalResultException {
        JsonElement json = this.parseJson(response.getResponse());
        if (!json.isJsonObject()) {
            throw new IllegalResultException("Unable to read the result : the result isn't an object");
        }
        JsonObject result = json.getAsJsonObject();
        if (!result.get("type").isJsonPrimitive() || !result.getAsJsonPrimitive("type").isString()) {
            throw new IllegalResultException("Expected type to be a string");
        }
        CafetData parsed = (CafetData)this.getClassDecoder().fromJson((JsonElement)result, this.classOfS);
        return new DataResult<CafetData>(Status.OK, this.getComputing(response), parsed);
    }

    public static <T extends CafetData> DataResult<T> parseResponse(HTTPResponse response, Class<T> classOfT) throws MissingResultElementException, IllegalResultException {
        return new DataParser<T>(classOfT).parse(response);
    }
}

