/*
 * Decompiled with CFR 0.152.
 */
package net.nowtryz.cafetapi.utils;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;

public class Base64Coder {
    public static Image decodeImage(String image) {
        if (image == null || image.isEmpty()) {
            return null;
        }
        try {
            byte[] bytes = Base64.getDecoder().decode(image);
            return ImageIO.read(new ByteArrayInputStream(bytes));
        }
        catch (IOException | IllegalArgumentException e) {
            e.printStackTrace();
            return new BufferedImage(20, 20, 3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encodeImage(Image image, String format) {
        if (image == null) return "";
        if (format == null) return "";
        if (format.isEmpty()) {
            return "";
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)((Object)image), format, baos);
            byte[] bytes = baos.toByteArray();
            String string = Base64.getEncoder().encodeToString(bytes);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

