/*
 * Decompiled with CFR 0.152.
 */
package net.nurigo.java_sdk.api;

import java.util.HashMap;
import net.nurigo.java_sdk.Coolsms;
import net.nurigo.java_sdk.exceptions.CoolsmsException;
import net.nurigo.java_sdk.exceptions.CoolsmsSDKException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class GroupMessage
extends Coolsms {
    public GroupMessage(String apiKey, String apiSecret) {
        super(apiKey, apiSecret);
    }

    public JSONObject createGroup(HashMap<String, String> params) throws CoolsmsException {
        return this.sendGetRequest("new_group", params);
    }

    public JSONObject getGroupList() throws CoolsmsException {
        HashMap<String, String> params = new HashMap<String, String>();
        return this.sendGetRequest("group_list", params);
    }

    public JSONObject deleteGroups(String groupIDs) throws CoolsmsException {
        if (!this.checkString(groupIDs)) {
            throw new CoolsmsSDKException("group_ids is required", 202);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("group_ids", groupIDs);
        return this.sendPostRequest("delete_groups", params);
    }

    public JSONObject getGroupInfo(String groupID) throws CoolsmsException {
        if (!this.checkString(groupID)) {
            throw new CoolsmsSDKException("group_id is required", 202);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("group_id", groupID);
        String resource = "groups/" + groupID;
        return this.sendGetRequest(resource, params);
    }

    public JSONObject addMessages(HashMap<String, String> params) throws CoolsmsException {
        if (!(this.checkString(params.get("group_id")) && this.checkString(params.get("to")) && this.checkString(params.get("from")) && this.checkString(params.get("text")))) {
            throw new CoolsmsSDKException("group_id, to, text, from is required", 202);
        }
        String resource = "groups/" + params.get("group_id") + "/add_messages";
        return this.sendPostRequest(resource, params);
    }

    public JSONObject addMessagesJSON(String group_id, JSONArray messages) throws CoolsmsException {
        if (!this.checkString(group_id) || messages.size() < 1) {
            throw new CoolsmsSDKException("group_id, messages is required", 202);
        }
        JSONObject item = null;
        int i = 0;
        while (i < messages.size()) {
            item = (JSONObject)messages.get(i);
            if (!(this.checkString(item.get((Object)"to").toString()) && this.checkString(item.get((Object)"text").toString()) && this.checkString(item.get((Object)"from").toString()))) {
                throw new CoolsmsSDKException("to, from, text is required", 202);
            }
            ++i;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("messages", messages.toString());
        String resource = "groups/" + group_id + "/add_messages.json";
        return this.sendPostRequest(resource, params);
    }

    public JSONObject getMessageList(HashMap<String, String> params) throws CoolsmsException {
        if (!this.checkString(params.get("group_id"))) {
            throw new CoolsmsSDKException("group_id is required", 202);
        }
        String resource = "groups/" + params.get("group_id") + "/message_list";
        return this.sendGetRequest(resource, params);
    }

    public JSONObject deleteMessages(String groupID, String messageIDs) throws CoolsmsException {
        if (!this.checkString(groupID) || !this.checkString(messageIDs)) {
            throw new CoolsmsSDKException("group_id and message_ids are required", 202);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("group_id", groupID);
        params.put("message_ids", messageIDs);
        String resource = "groups/" + (String)params.get("group_id") + "/delete_messages";
        return this.sendPostRequest(resource, params);
    }

    public JSONObject sendGroupMessage(String groupID) throws CoolsmsException {
        if (!this.checkString(groupID)) {
            throw new CoolsmsSDKException("group_id is required", 202);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("group_id", groupID);
        String resource = "groups/" + (String)params.get("group_id") + "/send";
        return this.sendPostRequest(resource, params);
    }
}

