/*
 * Decompiled with CFR 0.152.
 */
package net.nurigo.java_sdk.api;

import java.util.HashMap;
import net.nurigo.java_sdk.Coolsms;
import net.nurigo.java_sdk.exceptions.CoolsmsException;
import net.nurigo.java_sdk.exceptions.CoolsmsSDKException;
import org.json.simple.JSONObject;

public class Image
extends Coolsms {
    public Image(String apiKey, String apiSecret) {
        super(apiKey, apiSecret);
    }

    public JSONObject getImageList(HashMap<String, String> params) throws CoolsmsException {
        return this.sendGetRequest("image_list", params);
    }

    public JSONObject getImageInfo(String imageID) throws CoolsmsException {
        HashMap<String, String> params = new HashMap<String, String>();
        String resource = "images/" + imageID;
        return this.sendGetRequest(resource, params);
    }

    public JSONObject uploadImage(HashMap<String, String> params) throws CoolsmsException {
        if (!this.checkString(params.get("image"))) {
            throw new CoolsmsSDKException("image is required", 202);
        }
        return this.sendPostRequest("upload_image", params);
    }

    public JSONObject deleteImages(String imageIDs) throws CoolsmsException {
        if (!this.checkString(imageIDs)) {
            throw new CoolsmsSDKException("image_ids is required", 202);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("image_ids", imageIDs);
        return this.sendPostRequest("delete_images", params);
    }
}

