/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.util.ArrayList;
import java.util.List;
import net.objectlab.kit.datecalc.common.IMMDateCalculator;
import net.objectlab.kit.datecalc.common.IMMPeriod;

public abstract class AbstractIMMDateCalculator<E>
implements IMMDateCalculator<E> {
    protected static final int MONTHS_IN_QUARTER = 3;
    protected static final int MONTH_IN_YEAR = 12;
    protected static final int DAYS_IN_WEEK = 7;

    @Override
    public E getNextIMMDate(E startDate) {
        return this.getNextIMMDate(true, startDate, IMMPeriod.QUARTERLY);
    }

    @Override
    public E getNextIMMDate(E startDate, IMMPeriod period) {
        return this.getNextIMMDate(true, startDate, period);
    }

    @Override
    public E getPreviousIMMDate(E startDate) {
        return this.getNextIMMDate(false, startDate, IMMPeriod.QUARTERLY);
    }

    @Override
    public E getPreviousIMMDate(E startDate, IMMPeriod period) {
        return this.getNextIMMDate(false, startDate, period);
    }

    @Override
    public List<E> getIMMDates(E start, E end) {
        return this.getIMMDates(start, end, IMMPeriod.QUARTERLY);
    }

    @Override
    public List<E> getNextIMMDates(E start, int numberOfDates) {
        if (numberOfDates < 0) {
            throw new IllegalArgumentException("numberOfDates cannot be < 0 (" + numberOfDates + ")");
        }
        ArrayList<E> dates = new ArrayList<E>(numberOfDates);
        E date = start;
        for (int i = 0; i < numberOfDates; ++i) {
            date = this.getNextIMMDate(true, date, IMMPeriod.QUARTERLY);
            dates.add(date);
        }
        return dates;
    }

    protected abstract E getNextIMMDate(boolean var1, E var2, IMMPeriod var3);
}

