/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.objectlab.kit.datecalc.common.CurrencyDateCalculatorBuilder;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;
import net.objectlab.kit.datecalc.common.ImmutableHolidayCalendar;
import net.objectlab.kit.datecalc.common.KitCalculatorsFactory;
import net.objectlab.kit.datecalc.common.ccy.CurrencyCalculatorConfig;
import net.objectlab.kit.datecalc.common.ccy.DefaultCurrencyCalculatorConfig;

public abstract class AbstractKitCalculatorsFactory<E extends Serializable>
implements KitCalculatorsFactory<E> {
    private final ConcurrentMap<String, HolidayCalendar<E>> holidays = new ConcurrentHashMap<String, HolidayCalendar<E>>();
    private CurrencyCalculatorConfig currencyCalculatorConfig = new DefaultCurrencyCalculatorConfig();

    @Override
    public void setCurrencyCalculatorConfig(CurrencyCalculatorConfig config) {
        this.currencyCalculatorConfig = config;
    }

    @Override
    public CurrencyCalculatorConfig getCurrencyCalculatorConfig() {
        if (this.currencyCalculatorConfig == null) {
            this.currencyCalculatorConfig = new DefaultCurrencyCalculatorConfig();
        }
        return this.currencyCalculatorConfig;
    }

    @Override
    public KitCalculatorsFactory<E> registerHolidays(String name, HolidayCalendar<E> holidaysCalendar) {
        if (name != null) {
            HashSet hol = new HashSet();
            if (holidaysCalendar != null && holidaysCalendar.getHolidays() != null) {
                hol.addAll(holidaysCalendar.getHolidays());
            }
            DefaultHolidayCalendar<Serializable> defaultHolidayCalendar = new DefaultHolidayCalendar<Serializable>(hol);
            if (holidaysCalendar != null) {
                defaultHolidayCalendar.setEarlyBoundary((Serializable)holidaysCalendar.getEarlyBoundary());
                defaultHolidayCalendar.setLateBoundary((Serializable)holidaysCalendar.getLateBoundary());
            }
            this.holidays.put(name, new ImmutableHolidayCalendar<E>(holidaysCalendar));
        }
        return this;
    }

    @Override
    public boolean isHolidayCalendarRegistered(String name) {
        return name != null && this.holidays.containsKey(name);
    }

    @Override
    public HolidayCalendar<E> getHolidayCalendar(String name) {
        return (HolidayCalendar)this.holidays.get(name);
    }

    protected void setHolidays(String name, DateCalculator<E> dc) {
        if (name != null) {
            dc.setHolidayCalendar((HolidayCalendar)this.holidays.get(name));
        }
    }

    @Override
    public Set<String> getRegisteredHolidayCalendarNames() {
        return Collections.unmodifiableSet(this.holidays.keySet());
    }

    @Override
    public KitCalculatorsFactory<E> unregisterHolidayCalendar(String calendarName) {
        this.holidays.remove(calendarName);
        return this;
    }

    @Override
    public KitCalculatorsFactory<E> unregisterAllHolidayCalendars() {
        this.holidays.clear();
        return this;
    }

    protected CurrencyDateCalculatorBuilder<E> configureCurrencyCalculatorBuilder(CurrencyDateCalculatorBuilder<E> builder) {
        return builder.ccy1Calendar(this.getHolidayCalendar(builder.getCcy1())).ccy1Week(this.getCurrencyCalculatorConfig().getWorkingWeek(builder.getCcy1())).ccy2Calendar(this.getHolidayCalendar(builder.getCcy2())).ccy2Week(this.getCurrencyCalculatorConfig().getWorkingWeek(builder.getCcy2())).crossCcyCalendar(this.getHolidayCalendar(builder.getCrossCcy())).crossCcyWeek(this.getCurrencyCalculatorConfig().getWorkingWeek(builder.getCrossCcy())).currencyCalculatorConfig(this.getCurrencyCalculatorConfig());
    }
}

