/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;

public final class Utils {
    private static final String DATE_PATTERN = "yyyy-MM-dd";

    private Utils() {
    }

    public static Calendar blastTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Date createDate(String dateStr) {
        if (dateStr == null) {
            return Utils.createCalendar(null).getTime();
        }
        Calendar cal = Utils.getCal(dateStr);
        return cal != null ? cal.getTime() : null;
    }

    public static Calendar createCalendar(String dateStr) {
        if (dateStr == null) {
            return Utils.blastTime(Calendar.getInstance());
        }
        return Utils.getCal(dateStr);
    }

    public static Calendar getCal(String dateStr) {
        try {
            Date date = new SimpleDateFormat(DATE_PATTERN).parse(dateStr);
            return Utils.getCal(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\"" + dateStr + "\" is an invalid date, the pattern is : " + DATE_PATTERN, e);
        }
    }

    public static Calendar getCal(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return Utils.blastTime(cal);
    }

    public static Set<Calendar> toCalendarSet(Set<Date> dates) {
        return dates.stream().map(Utils::getCal).collect(Collectors.toSet());
    }

    public static HolidayCalendar<Calendar> toHolidayCalendarSet(HolidayCalendar<Date> dates) {
        HashSet<Calendar> calendars = new HashSet<Calendar>();
        for (Date date : dates.getHolidays()) {
            calendars.add(Utils.getCal(date));
        }
        return new DefaultHolidayCalendar<Calendar>(calendars, Utils.getCal((Date)dates.getEarlyBoundary()), Utils.getCal((Date)dates.getLateBoundary()));
    }

    public static Set<Date> toDateSet(Set<Calendar> calendars) {
        return calendars.stream().map(Calendar::getTime).collect(Collectors.toSet());
    }

    public static List<Date> toDateList(List<Calendar> dates) {
        return dates.stream().map(Calendar::getTime).collect(Collectors.toList());
    }
}

