/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common.ccy;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.objectlab.kit.datecalc.common.WorkingWeek;
import net.objectlab.kit.datecalc.common.ccy.CurrencyCalculatorConfig;

public class DefaultCurrencyCalculatorConfig
implements CurrencyCalculatorConfig {
    private Map<String, Set<String>> currenciesSubjectToCrossCcyForT1 = new HashMap<String, Set<String>>();
    private Map<String, WorkingWeek> workingWeeks = new HashMap<String, WorkingWeek>();

    public DefaultCurrencyCalculatorConfig() {
        HashSet<String> subjectToUsd = new HashSet<String>();
        subjectToUsd.add("MXN");
        subjectToUsd.add("CLP");
        subjectToUsd.add("ARS");
        this.currenciesSubjectToCrossCcyForT1.put("USD", subjectToUsd);
        this.workingWeeks.put("AED", WorkingWeek.ARABIC_WEEK);
        this.workingWeeks.put("BHD", WorkingWeek.ARABIC_WEEK);
        this.workingWeeks.put("EGP", WorkingWeek.ARABIC_WEEK);
        this.workingWeeks.put("KWD", WorkingWeek.ARABIC_WEEK);
        this.workingWeeks.put("OMR", WorkingWeek.ARABIC_WEEK);
        this.workingWeeks.put("QAR", WorkingWeek.ARABIC_WEEK);
        this.workingWeeks.put("SAR", WorkingWeek.ARABIC_WEEK.intersection(WorkingWeek.DEFAULT));
        this.workingWeeks.put("JOD", WorkingWeek.ARABIC_WEEK.intersection(WorkingWeek.DEFAULT));
    }

    public void setCurrenciesSubjectToCrossCcyForT1(Map<String, Set<String>> currenciesSubjectToCrossCcyForT1) {
        HashMap<String, Set<String>> copy = new HashMap<String, Set<String>>();
        if (currenciesSubjectToCrossCcyForT1 != null) {
            copy.putAll(currenciesSubjectToCrossCcyForT1);
        }
        this.currenciesSubjectToCrossCcyForT1 = copy;
    }

    public void setWorkingWeeks(Map<String, WorkingWeek> workingWeeks) {
        HashMap<String, WorkingWeek> ww = new HashMap<String, WorkingWeek>();
        ww.putAll(workingWeeks);
        this.workingWeeks = ww;
    }

    @Override
    public Set<String> getCurrenciesSubjectToCrossCcyForT1(String crossCcy) {
        Set<String> s = this.currenciesSubjectToCrossCcyForT1.get(crossCcy);
        return s != null ? Collections.unmodifiableSet(s) : Collections.emptySet();
    }

    @Override
    public WorkingWeek getWorkingWeek(String currency) {
        WorkingWeek workingWeek = this.workingWeeks.get(currency);
        return workingWeek != null ? workingWeek : WorkingWeek.DEFAULT;
    }
}

