/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.ImmutableHolidayCalendar;
import net.objectlab.kit.datecalc.common.Tenor;
import net.objectlab.kit.datecalc.common.TenorCode;

public abstract class AbstractDateCalculator<E extends Serializable>
implements DateCalculator<E> {
    private static final int MONTHS_IN_YEAR = 12;
    protected static final int DAYS_IN_WEEK = 7;
    private String name;
    private E startDate;
    private E currentBusinessDate;
    private HolidayCalendar<E> holidayCalendar;
    private HolidayHandler<E> holidayHandler;
    private int currentIncrement;

    protected AbstractDateCalculator(String name, HolidayCalendar<E> holidayCalendar, HolidayHandler<E> holidayHandler) {
        this.name = name;
        this.holidayCalendar = holidayCalendar != null ? new ImmutableHolidayCalendar<E>(holidayCalendar) : new ImmutableHolidayCalendar(new DefaultHolidayCalendar());
        this.holidayHandler = holidayHandler;
    }

    @Override
    public DateCalculator<E> setHolidayCalendar(HolidayCalendar<E> calendar) {
        this.holidayCalendar = calendar != null ? (calendar instanceof ImmutableHolidayCalendar ? calendar : new ImmutableHolidayCalendar<E>(calendar)) : new ImmutableHolidayCalendar(new DefaultHolidayCalendar());
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public E getStartDate() {
        if (this.startDate == null) {
            this.startDate = this.getToday();
        }
        return this.startDate;
    }

    @Override
    public DateCalculator<E> setStartDate(E startDate) {
        this.startDate = startDate;
        this.setCurrentBusinessDate(startDate);
        return this;
    }

    @Override
    public E getCurrentBusinessDate() {
        if (this.currentBusinessDate == null) {
            this.currentBusinessDate = this.getToday();
        }
        return this.currentBusinessDate;
    }

    @Override
    public DateCalculator<E> moveByTenor(Tenor tenor, int spotLag) {
        if (tenor == null) {
            throw new IllegalArgumentException("Tenor cannot be null");
        }
        TenorCode tenorCode = tenor.getCode();
        if (tenorCode != TenorCode.OVERNIGHT && tenorCode != TenorCode.TOM_NEXT) {
            this.moveToSpotDate(spotLag);
        }
        int unit = tenor.getUnits();
        if (tenorCode == TenorCode.WEEK) {
            tenorCode = TenorCode.DAY;
            unit *= 7;
        }
        if (tenorCode == TenorCode.YEAR) {
            tenorCode = TenorCode.MONTH;
            unit *= 12;
        }
        return this.applyTenor(tenorCode, unit);
    }

    protected DateCalculator<E> applyTenor(TenorCode tenorCode, int unit) {
        DateCalculator<E> calc;
        switch (tenorCode) {
            case OVERNIGHT: {
                calc = this.moveByDays(1);
                break;
            }
            case TOM_NEXT: {
                this.moveByDays(1);
                calc = this.moveByDays(1);
                break;
            }
            case SPOT_NEXT: {
                calc = this.moveByDays(1);
                break;
            }
            case SPOT: {
                calc = this;
                break;
            }
            case DAY: {
                calc = this.moveByDays(unit);
                break;
            }
            case MONTH: {
                calc = this.moveByMonths(unit);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Sorry not yet...");
            }
        }
        return calc;
    }

    @Override
    public DateCalculator<E> moveByTenor(Tenor tenor) {
        return this.moveByTenor(tenor, 0);
    }

    @Override
    public List<E> calculateTenorDates(List<Tenor> tenors) {
        return this.calculateTenorDates(tenors, 0);
    }

    @Override
    public List<E> calculateTenorDates(List<Tenor> tenors, int spotLag) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (tenors != null) {
            Object originalDate = this.clone(this.getCurrentBusinessDate());
            for (Tenor tenor : tenors) {
                this.moveByTenor(tenor, spotLag);
                list.add(this.getCurrentBusinessDate());
                this.setCurrentBusinessDate((E)originalDate);
            }
        }
        return list;
    }

    protected abstract DateCalculator<E> moveByMonths(int var1);

    public DateCalculator<E> setHolidayHandler(HolidayHandler<E> holidayHandler) {
        this.holidayHandler = holidayHandler;
        return this;
    }

    @Override
    public String getHolidayHandlerType() {
        return this.holidayHandler != null ? this.holidayHandler.getType() : null;
    }

    @Override
    public boolean isNonWorkingDay(E date) {
        if (date != null && (this.holidayCalendar.getEarlyBoundary() != null || this.holidayCalendar.getLateBoundary() != null)) {
            this.checkBoundary(date);
        }
        return this.isWeekend(date) || this.holidayCalendar.isHoliday(date);
    }

    protected abstract void checkBoundary(E var1);

    @Override
    public boolean isCurrentDateNonWorking() {
        if (this.currentBusinessDate == null) {
            this.currentBusinessDate = this.getToday();
        }
        return this.isNonWorkingDay(this.currentBusinessDate);
    }

    @Override
    public E forceCurrentDateNoAdjustment(E date) {
        this.currentBusinessDate = date;
        return this.currentBusinessDate;
    }

    @Override
    public E setCurrentBusinessDate(E date) {
        this.currentBusinessDate = date;
        if (this.holidayHandler != null && date != null) {
            this.currentBusinessDate = (Serializable)this.holidayHandler.moveCurrentDate(this);
        }
        if (date != null && (this.holidayCalendar.getEarlyBoundary() != null || this.holidayCalendar.getLateBoundary() != null)) {
            this.checkBoundary(date);
        }
        return this.currentBusinessDate;
    }

    public HolidayHandler<E> getHolidayHandler() {
        return this.holidayHandler;
    }

    protected void moveToSpotDate(int spotLag) {
        this.moveByBusinessDays(spotLag);
    }

    @Override
    public DateCalculator<E> moveByBusinessDays(int businessDays) {
        this.checkHolidayValidity(businessDays);
        int numberOfStepsLeft = Math.abs(businessDays);
        int step = businessDays < 0 ? -1 : 1;
        for (int i = 0; i < numberOfStepsLeft; ++i) {
            this.moveByDays(step);
        }
        return this;
    }

    private void checkHolidayValidity(int businessDays) {
        if (businessDays > 0 && this.holidayHandler != null && (this.holidayHandler.getType().equals("backward") || this.holidayHandler.getType().equals("modifiedPreceding"))) {
            throw new IllegalArgumentException("A modifiedPreceding or backward does not allow positive steps for moveByBusinessDays");
        }
        if (businessDays < 0 && this.holidayHandler != null && (this.holidayHandler.getType().equals("forward") || this.holidayHandler.getType().equals("modifiedFollowing"))) {
            throw new IllegalArgumentException("A modifiedFollowing or forward does not allow negative steps for moveByBusinessDays");
        }
    }

    @Override
    public DateCalculator<E> combine(DateCalculator<E> calculator) {
        if (calculator == null || calculator == this) {
            return this;
        }
        this.checkHolidayHandlerValidity(calculator);
        HashSet newSet = new HashSet();
        if (this.holidayCalendar != null) {
            newSet.addAll(this.holidayCalendar.getHolidays());
        }
        HolidayCalendar<E> calendarToCombine = calculator.getHolidayCalendar();
        this.checkBoundaries(calendarToCombine);
        if (calendarToCombine.getHolidays() != null) {
            newSet.addAll(calendarToCombine.getHolidays());
        }
        DefaultHolidayCalendar<Serializable> newCal = new DefaultHolidayCalendar<Serializable>(newSet, this.compareDate((Serializable)this.holidayCalendar.getEarlyBoundary(), (Serializable)calendarToCombine.getEarlyBoundary(), false), this.compareDate((Serializable)this.holidayCalendar.getLateBoundary(), (Serializable)calendarToCombine.getLateBoundary(), true));
        return this.createNewCalculator(this.getName() + "/" + calculator.getName(), this.getStartDate(), newCal, this.holidayHandler);
    }

    private void checkHolidayHandlerValidity(DateCalculator<E> calculator) {
        if (this.holidayHandler == null && calculator.getHolidayHandlerType() != null || this.holidayHandler != null && !this.holidayHandler.getType().equals(calculator.getHolidayHandlerType())) {
            throw new IllegalArgumentException("Combined Calendars cannot have different handler types");
        }
    }

    private void checkBoundaries(HolidayCalendar<E> calendarToCombine) {
        if (calendarToCombine.getEarlyBoundary() != null && this.holidayCalendar.getEarlyBoundary() == null || calendarToCombine.getEarlyBoundary() == null && this.holidayCalendar.getEarlyBoundary() != null) {
            throw new IllegalArgumentException("Both Calendar to be combined must either have each Early boundaries or None.");
        }
        if (calendarToCombine.getLateBoundary() != null && this.holidayCalendar.getLateBoundary() == null || calendarToCombine.getLateBoundary() == null && this.holidayCalendar.getLateBoundary() != null) {
            throw new IllegalArgumentException("Both Calendar to be combined must either have each Late boundaries or None.");
        }
    }

    protected abstract E getToday();

    protected abstract E compareDate(E var1, E var2, boolean var3);

    protected abstract DateCalculator<E> createNewCalculator(String var1, E var2, HolidayCalendar<E> var3, HolidayHandler<E> var4);

    @Override
    public int getCurrentIncrement() {
        return this.currentIncrement;
    }

    @Override
    public DateCalculator<E> setCurrentIncrement(int currentIncrement) {
        this.currentIncrement = currentIncrement;
        return this;
    }

    @Override
    public HolidayCalendar<E> getHolidayCalendar() {
        return this.holidayCalendar;
    }

    protected abstract E clone(E var1);
}

