/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk;

import java.util.Calendar;
import net.objectlab.kit.datecalc.common.AbstractKitCalculatorsFactory;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.IMMDateCalculator;
import net.objectlab.kit.datecalc.common.PeriodCountCalculator;
import net.objectlab.kit.datecalc.jdk.CalendarBackwardHandler;
import net.objectlab.kit.datecalc.jdk.CalendarDateCalculator;
import net.objectlab.kit.datecalc.jdk.CalendarForwardHandler;
import net.objectlab.kit.datecalc.jdk.CalendarForwardUnlessNegativeHandler;
import net.objectlab.kit.datecalc.jdk.CalendarIMMDateCalculator;
import net.objectlab.kit.datecalc.jdk.CalendarModifiedFollowingHandler;
import net.objectlab.kit.datecalc.jdk.CalendarModifiedPrecedingHandler;
import net.objectlab.kit.datecalc.jdk.CalendarPeriodCountCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarKitCalculatorsFactory
extends AbstractKitCalculatorsFactory<Calendar> {
    private static final CalendarKitCalculatorsFactory DEFAULT = new CalendarKitCalculatorsFactory();
    private static final PeriodCountCalculator<Calendar> PCC = new CalendarPeriodCountCalculator();
    private static final CalendarIMMDateCalculator IMMDC = new CalendarIMMDateCalculator();

    public static CalendarKitCalculatorsFactory getDefaultInstance() {
        return DEFAULT;
    }

    @Override
    public DateCalculator<Calendar> getDateCalculator(String name, String holidayHandlerType) {
        CalendarDateCalculator cal = new CalendarDateCalculator();
        cal.setName(name);
        this.setHolidays(name, cal);
        if (holidayHandlerType == null) {
            return cal;
        }
        if ("forward".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new CalendarForwardHandler());
        } else if ("backward".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new CalendarBackwardHandler());
        } else if ("modifiedFollowing".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new CalendarModifiedFollowingHandler());
        } else if ("modifiedPreceding".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new CalendarModifiedPrecedingHandler());
        } else if ("forwardUnlessMovingBack".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new CalendarForwardUnlessNegativeHandler());
        } else {
            throw new IllegalArgumentException("Unsupported HolidayHandler: " + holidayHandlerType);
        }
        return cal;
    }

    @Override
    public PeriodCountCalculator<Calendar> getPeriodCountCalculator() {
        return PCC;
    }

    @Override
    public IMMDateCalculator<Calendar> getIMMDateCalculator() {
        return IMMDC;
    }
}

