/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.joda;

import java.io.Serializable;
import java.util.Collections;
import net.objectlab.kit.datecalc.common.AbstractDateCalculator;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.WorkingWeek;
import net.objectlab.kit.datecalc.joda.JodaWorkingWeek;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class LocalDateCalculator
extends AbstractDateCalculator<LocalDate> {
    private JodaWorkingWeek workingWeek = JodaWorkingWeek.DEFAULT;

    public LocalDateCalculator() {
        this(null, null, new DefaultHolidayCalendar<LocalDate>(Collections.emptySet()), null);
    }

    public LocalDateCalculator(String name, LocalDate startDate, HolidayCalendar<LocalDate> holidayCalendar, HolidayHandler<LocalDate> holidayHandler) {
        super(name, holidayCalendar, holidayHandler);
        if (startDate != null) {
            this.setStartDate(startDate);
        }
    }

    @Override
    public DateCalculator<LocalDate> setWorkingWeek(WorkingWeek week) {
        if (week instanceof JodaWorkingWeek) {
            this.workingWeek = (JodaWorkingWeek)week;
            return this;
        }
        throw new IllegalArgumentException("Please give an instance of JodaWorkingWeek");
    }

    @Override
    public boolean isWeekend(LocalDate date) {
        assert (this.workingWeek != null);
        return !this.workingWeek.isWorkingDay(date);
    }

    @Override
    public DateCalculator<LocalDate> moveByDays(int days) {
        this.setCurrentIncrement(days);
        this.setCurrentBusinessDate(((LocalDate)this.getCurrentBusinessDate()).plusDays(days));
        if (this.getHolidayHandler() != null) {
            this.setCurrentBusinessDate((Serializable)this.getHolidayHandler().moveCurrentDate(this));
        }
        return this;
    }

    @Override
    public DateCalculator<LocalDate> moveByMonths(int months) {
        this.setCurrentIncrement(months);
        this.setCurrentBusinessDate(((LocalDate)this.getCurrentBusinessDate()).plusMonths(months));
        if (this.getHolidayHandler() != null) {
            this.setCurrentBusinessDate((Serializable)this.getHolidayHandler().moveCurrentDate(this));
        }
        return this;
    }

    @Override
    protected DateCalculator<LocalDate> createNewCalculator(String name, LocalDate startDate, HolidayCalendar<LocalDate> holidays, HolidayHandler<LocalDate> handler) {
        return new LocalDateCalculator(name, startDate, holidays, handler);
    }

    @Override
    protected LocalDate getToday() {
        return new LocalDate();
    }

    @Override
    protected LocalDate compareDate(LocalDate date1, LocalDate date2, boolean returnEarliest) {
        if (date1 == null || date2 == null) {
            return null;
        }
        if (returnEarliest) {
            return date1.isAfter((ReadablePartial)date2) ? date2 : date1;
        }
        return date2.isAfter((ReadablePartial)date1) ? date2 : date1;
    }

    @Override
    protected void checkBoundary(LocalDate date) {
        LocalDate early = (LocalDate)this.getHolidayCalendar().getEarlyBoundary();
        if (early != null && early.isAfter((ReadablePartial)date)) {
            throw new IndexOutOfBoundsException(date + " is before the early boundary " + early);
        }
        LocalDate late = (LocalDate)this.getHolidayCalendar().getLateBoundary();
        if (late != null && late.isBefore((ReadablePartial)date)) {
            throw new IndexOutOfBoundsException(date + " is after the late boundary " + late);
        }
    }

    @Override
    protected LocalDate clone(LocalDate date) {
        return date;
    }

    @Override
    public int getNumberOfBusinessDaysBetween(LocalDate d1, LocalDate d2) {
        LocalDate end;
        if (d1 == null || d2 == null) {
            return 0;
        }
        boolean d1B4d2 = !d1.isAfter((ReadablePartial)d2);
        LocalDate start = d1B4d2 ? d1 : d2;
        LocalDate localDate = end = d1B4d2 ? d2 : d1;
        if (this.getHolidayHandler() != null) {
            start = this.getHolidayHandler().adjustDate(start, 1, this);
        }
        int count = 0;
        while (start.isBefore((ReadablePartial)end)) {
            if (!this.isNonWorkingDay(start)) {
                ++count;
            }
            start = start.plusDays(1);
        }
        return d1B4d2 ? count : -count;
    }
}

