/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.joda;

import net.objectlab.kit.datecalc.common.BaseCalculator;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.NonWorkingDayChecker;
import org.joda.time.LocalDate;

public class LocalDateForwardHandler
implements HolidayHandler<LocalDate> {
    @Override
    public LocalDate moveCurrentDate(BaseCalculator<LocalDate> calculator) {
        return this.adjustDate(calculator.getCurrentBusinessDate(), 1, (NonWorkingDayChecker<LocalDate>)calculator);
    }

    @Override
    public LocalDate adjustDate(LocalDate startDate, int increment, NonWorkingDayChecker<LocalDate> checker) {
        LocalDate date = startDate;
        while (checker.isNonWorkingDay(date)) {
            date = date.plusDays(increment);
        }
        return date;
    }

    @Override
    public String getType() {
        return "forward";
    }
}

