/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.joda;

import net.objectlab.kit.datecalc.common.BaseCalculator;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.NonWorkingDayChecker;
import org.joda.time.LocalDate;

public class LocalDateForwardUnlessNegativeHandler
implements HolidayHandler<LocalDate> {
    @Override
    public LocalDate moveCurrentDate(BaseCalculator<LocalDate> calculator) {
        return this.adjustDate(calculator.getCurrentBusinessDate(), calculator.getCurrentIncrement(), (NonWorkingDayChecker<LocalDate>)calculator);
    }

    @Override
    public LocalDate adjustDate(LocalDate startDate, int increment, NonWorkingDayChecker<LocalDate> checker) {
        LocalDate date = startDate;
        while (checker.isNonWorkingDay(date)) {
            if (increment < 0) {
                date = date.minusDays(1);
                continue;
            }
            date = date.plusDays(1);
        }
        return date;
    }

    @Override
    public String getType() {
        return "forwardUnlessMovingBack";
    }
}

