/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.cdi.tester.contexts;

import com.oneandone.cdi.tester.contexts.internal.InitialListener;
import com.oneandone.cdi.tester.contexts.internal.servlet.LifecycleAwareRequest;
import com.oneandone.cdi.tester.contexts.servlet.CdiUnitServlet;
import com.oneandone.cdi.tester.contexts.servlet.MockHttpServletRequestImpl;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.http.Http;

@ApplicationScoped
public class ContextController {
    private ThreadLocal<HttpServletRequest> requests;
    @Inject
    private BeanManager beanManager;
    private HttpSession currentSession;
    @Inject
    @CdiUnitServlet
    private ServletContext context;
    @Inject
    @CdiUnitServlet
    private HttpSession session;
    @Inject
    private InitialListener listener;
    @Inject
    @CdiUnitServlet
    private Provider<MockHttpServletRequestImpl> requestProvider;
    @Inject
    @Http
    private ConversationContext conversationContext;

    @PostConstruct
    void initContext() {
        this.requests = new ThreadLocal();
        this.listener.contextInitialized(new ServletContextEvent(this.context));
    }

    @PreDestroy
    void destroyContext() {
        this.listener.contextDestroyed(new ServletContextEvent(this.context));
        this.requests = null;
    }

    public HttpServletRequest openRequest() {
        HttpServletRequest currentRequest = this.requests.get();
        if (currentRequest != null) {
            throw new RuntimeException("A request is already open");
        }
        MockHttpServletRequestImpl request = (MockHttpServletRequestImpl)this.requestProvider.get();
        if (this.currentSession != null) {
            request.setSession(this.currentSession);
            request.getSession();
        }
        currentRequest = new LifecycleAwareRequest(this.listener, request);
        this.requests.set(currentRequest);
        this.listener.requestInitialized(new ServletRequestEvent(this.context, (ServletRequest)currentRequest));
        if (!this.conversationContext.isActive()) {
            this.conversationContext.activate();
        }
        return currentRequest;
    }

    public HttpServletRequest currentRequest() {
        HttpServletRequest currentRequest = this.requests.get();
        if (currentRequest == null) {
            throw new RuntimeException("A request has not been opened");
        }
        return currentRequest;
    }

    public void closeRequest() {
        HttpServletRequest currentRequest = this.requests.get();
        if (currentRequest != null) {
            this.listener.requestDestroyed(new ServletRequestEvent(this.context, (ServletRequest)currentRequest));
            this.currentSession = currentRequest.getSession(false);
        }
        this.requests.remove();
    }

    public void closeSession() {
        HttpServletRequest currentRequest = this.requests.get();
        if (currentRequest != null) {
            this.currentSession = currentRequest.getSession(false);
        }
        if (this.currentSession != null) {
            this.listener.sessionDestroyed(new HttpSessionEvent(this.currentSession));
            this.currentSession = null;
        }
    }

    public HttpSession getSession() {
        return this.currentSession;
    }
}

