/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.cdi.tester.contexts.jaxrs;

import com.oneandone.cdi.tester.contexts.ContextController;
import com.oneandone.cdi.tester.contexts.jaxrs.JaxRsQualifier;
import com.oneandone.cdi.tester.contexts.jaxrs.RequestImpl;
import com.oneandone.cdi.tester.contexts.servlet.CdiUnitServlet;
import com.oneandone.cdi.tester.contexts.servlet.MockHttpServletResponseImpl;
import com.oneandone.cdi.tester.contexts.servlet.MockServletContextImpl;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.mockito.Mockito;

public class JaxRsProducers {
    @Inject
    @CdiUnitServlet
    MockServletContextImpl servletContext;
    @Inject
    ContextController contextController;

    @Produces
    @JaxRsQualifier
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Produces
    @RequestScoped
    @JaxRsQualifier
    public HttpServletRequest getHttpServletRequest() {
        return this.contextController.currentRequest();
    }

    @Produces
    @RequestScoped
    @JaxRsQualifier
    public HttpServletResponse getHttpServletResponse() {
        return new MockHttpServletResponseImpl();
    }

    @Produces
    @SessionScoped
    @JaxRsQualifier
    public HttpSession getHttpSession() {
        return this.contextController.currentRequest().getSession();
    }

    @Produces
    @JaxRsQualifier
    public SecurityContext getSecurityContext() {
        return (SecurityContext)Mockito.mock(SecurityContext.class);
    }

    @Produces
    @RequestScoped
    @JaxRsQualifier
    public Request getRequest() {
        return new RequestImpl(this.getHttpServletRequest(), this.getHttpServletResponse());
    }

    @Produces
    @RequestScoped
    @JaxRsQualifier
    public UriInfo getUriInfo() {
        return ServletUtil.extractUriInfo((HttpServletRequest)this.getHttpServletRequest(), (String)"");
    }

    @Produces
    @RequestScoped
    @JaxRsQualifier
    public HttpHeaders getHttpHeaders() {
        return ServletUtil.extractHttpHeaders((HttpServletRequest)this.getHttpServletRequest());
    }

    @Produces
    @RequestScoped
    @JaxRsQualifier
    public Providers getProviders() {
        return (Providers)Mockito.mock(Providers.class);
    }
}

