/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.cdi.tester.contexts.servlet;

import com.oneandone.cdi.tester.contexts.servlet.AsyncContextImpl;
import com.oneandone.cdi.tester.contexts.servlet.CdiUnitServlet;
import com.oneandone.cdi.tester.contexts.servlet.MockHttpSessionImpl;
import com.oneandone.cdi.tester.contexts.servlet.MockRequestDispatcher;
import com.oneandone.cdi.tester.contexts.servlet.MockServletInputStream;
import com.oneandone.cdi.tester.contexts.servlet.NestedApplicationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.inject.Inject;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

@CdiUnitServlet
public class MockHttpServletRequestImpl
implements HttpServletRequest {
    private Map attributes;
    private Map parameters;
    private Vector locales;
    private Map requestDispatchers;
    private String method;
    private String authType;
    private Map headers;
    private String contextPath;
    private String pathInfo;
    private String pathTranslated;
    private String queryString;
    private StringBuffer requestUrl;
    private String requestUri;
    private String servletPath;
    private Principal principal;
    private String remoteUser;
    private boolean requestedSessionIdIsFromCookie;
    private String protocol;
    private String serverName;
    private int serverPort;
    private String scheme;
    private String remoteHost;
    private String remoteAddr;
    private Map roles;
    private String characterEncoding;
    private long contentLength;
    private String contentType;
    private List cookies;
    private MockServletInputStream bodyContent;
    private String localAddr;
    private String localName;
    private int localPort;
    private int remotePort;
    private boolean sessionCreated;
    private List attributeListener;
    private boolean isAsyncSupported;
    @Inject
    @CdiUnitServlet
    private ServletContext servletContext;
    @Inject
    @CdiUnitServlet
    private HttpSession session;
    private AsyncContextImpl asyncContext;

    public MockHttpServletRequestImpl() {
        this.resetAll();
    }

    public void resetAll() {
        this.attributes = new HashMap();
        this.parameters = new HashMap();
        this.locales = new Vector();
        this.requestDispatchers = new HashMap();
        this.method = "GET";
        this.headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.requestedSessionIdIsFromCookie = true;
        this.protocol = "HTTP/1.1";
        this.serverName = "localhost";
        this.serverPort = 8080;
        this.scheme = "http";
        this.remoteHost = "localhost";
        this.remoteAddr = "127.0.0.1";
        this.roles = new HashMap();
        this.contentLength = -1L;
        this.cookies = null;
        this.localAddr = "127.0.0.1";
        this.localName = "localhost";
        this.localPort = 8080;
        this.remotePort = 5000;
        this.sessionCreated = false;
        this.attributeListener = new ArrayList();
        this.bodyContent = new MockServletInputStream(new byte[0]);
        this.isAsyncSupported = false;
    }

    public void addAttributeListener(ServletRequestAttributeListener listener) {
        this.attributeListener.add(listener);
    }

    public String getParameter(String key) {
        String[] values = this.getParameterValues(key);
        if (null != values && 0 < values.length) {
            return values[0];
        }
        return null;
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public String[] getParameterValues(String key) {
        return (String[])this.parameters.get(key);
    }

    public void setupAddParameter(String key, String[] values) {
        this.parameters.put(key, values);
    }

    public void setupAddParameter(String key, String value) {
        this.setupAddParameter(key, new String[]{value});
    }

    public Enumeration getParameterNames() {
        Vector parameterKeys = new Vector(this.parameters.keySet());
        return parameterKeys.elements();
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Enumeration getAttributeNames() {
        Vector attKeys = new Vector(this.attributes.keySet());
        return attKeys.elements();
    }

    public void removeAttribute(String key) {
        Object value = this.attributes.get(key);
        this.attributes.remove(key);
        if (null != value) {
            this.callAttributeListenersRemovedMethod(key, value);
        }
    }

    public void setAttribute(String key, Object value) {
        Object oldValue = this.attributes.get(key);
        if (null == value) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
        this.handleAttributeListenerCalls(key, value, oldValue);
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        return null;
    }

    public HttpSession getSession(boolean create) {
        if (!create && !this.sessionCreated) {
            return null;
        }
        if (create) {
            this.sessionCreated = true;
            if (this.session instanceof MockHttpSessionImpl && !((MockHttpSessionImpl)this.session).isValid()) {
                ((MockHttpSessionImpl)this.session).resetAll();
            }
        }
        return this.session;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        RequestDispatcher dispatcher = (RequestDispatcher)this.requestDispatchers.get(path);
        if (null == dispatcher) {
            dispatcher = new MockRequestDispatcher();
            this.setRequestDispatcher(path, dispatcher);
        }
        return dispatcher;
    }

    public Map getRequestDispatcherMap() {
        return Collections.unmodifiableMap(this.requestDispatchers);
    }

    public void clearRequestDispatcherMap() {
        this.requestDispatchers.clear();
    }

    public void setRequestDispatcher(String path, RequestDispatcher dispatcher) {
        if (dispatcher instanceof MockRequestDispatcher) {
            ((MockRequestDispatcher)dispatcher).setPath(path);
        }
        this.requestDispatchers.put(path, dispatcher);
    }

    public Locale getLocale() {
        if (this.locales.size() < 1) {
            return Locale.getDefault();
        }
        return (Locale)this.locales.get(0);
    }

    public Enumeration getLocales() {
        return this.locales.elements();
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void addLocales(List localeList) {
        this.locales.addAll(localeList);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public long getDateHeader(String key) {
        String header = this.getHeader(key);
        if (null == header) {
            return -1L;
        }
        try {
            Date dateValue = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US).parse(header);
            return dateValue.getTime();
        }
        catch (ParseException exc) {
            throw new IllegalArgumentException(exc.getMessage());
        }
    }

    public String getHeader(String key) {
        List headerList = (List)this.headers.get(key);
        if (null == headerList || 0 == headerList.size()) {
            return null;
        }
        return (String)headerList.get(0);
    }

    public Enumeration getHeaderNames() {
        return new Vector(this.headers.keySet()).elements();
    }

    public Enumeration getHeaders(String key) {
        List headerList = (List)this.headers.get(key);
        if (null == headerList) {
            return new Vector().elements();
        }
        return new Vector(headerList).elements();
    }

    public int getIntHeader(String key) {
        String header = this.getHeader(key);
        if (null == header) {
            return -1;
        }
        return new Integer(header);
    }

    public void addHeader(String key, String value) {
        ArrayList<String> valueList = (ArrayList<String>)this.headers.get(key);
        if (null == valueList) {
            valueList = new ArrayList<String>();
            this.headers.put(key, valueList);
        }
        valueList.add(value);
    }

    public void setHeader(String key, String value) {
        ArrayList<String> valueList = new ArrayList<String>();
        this.headers.put(key, valueList);
        valueList.add(value);
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public void setPathTranslated(String pathTranslated) {
        this.pathTranslated = pathTranslated;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRequestURI() {
        return this.requestUri;
    }

    public void setRequestURI(String requestUri) {
        this.requestUri = requestUri;
    }

    public StringBuffer getRequestURL() {
        return this.requestUrl;
    }

    public void setRequestURL(String requestUrl) {
        this.requestUrl = new StringBuffer(requestUrl);
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public void setUserPrincipal(Principal principal) {
        this.principal = principal;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public Cookie[] getCookies() {
        if (null == this.cookies) {
            return null;
        }
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public void addCookie(Cookie cookie) {
        if (null == this.cookies) {
            this.cookies = new ArrayList();
        }
        this.cookies.add(cookie);
    }

    public String getRequestedSessionId() {
        HttpSession session = this.getSession();
        if (null == session) {
            return null;
        }
        return session.getId();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdIsFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return !this.requestedSessionIdIsFromCookie;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdIsFromCookie) {
        this.requestedSessionIdIsFromCookie = requestedSessionIdIsFromCookie;
    }

    public boolean isRequestedSessionIdValid() {
        HttpSession session = this.getSession();
        return null != session;
    }

    public boolean isUserInRole(String role) {
        if (!this.roles.containsKey(role)) {
            return false;
        }
        return (Boolean)this.roles.get(role);
    }

    public void setUserInRole(String role, boolean isInRole) {
        this.roles.put(role, new Boolean(isInRole));
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.characterEncoding = characterEncoding;
    }

    public int getContentLength() {
        return (int)this.contentLength;
    }

    public long getContentLengthLong() {
        return 0L;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)((Object)this.bodyContent)));
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.bodyContent;
    }

    public void setBodyContent(byte[] data) {
        this.bodyContent = new MockServletInputStream(data);
    }

    public void setBodyContent(String bodyContent) {
        String encoding = null == this.characterEncoding ? "ISO-8859-1" : this.characterEncoding;
        try {
            this.setBodyContent(bodyContent.getBytes(encoding));
        }
        catch (UnsupportedEncodingException exc) {
            throw new NestedApplicationException(exc);
        }
    }

    public String getRealPath(String path) {
        HttpSession session = this.getSession();
        if (null == session) {
            return null;
        }
        return session.getServletContext().getRealPath(path);
    }

    public boolean isSecure() {
        String scheme = this.getScheme();
        if (null == scheme) {
            return false;
        }
        return scheme.equals("https");
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public boolean isAsyncSupported() {
        return this.isAsyncSupported;
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
        this.isAsyncSupported = isAsyncSupported;
    }

    private void handleAttributeListenerCalls(String key, Object value, Object oldValue) {
        if (null != oldValue) {
            if (value != null) {
                this.callAttributeListenersReplacedMethod(key, oldValue);
            } else {
                this.callAttributeListenersRemovedMethod(key, oldValue);
            }
        } else if (value != null) {
            this.callAttributeListenersAddedMethod(key, value);
        }
    }

    private void callAttributeListenersAddedMethod(String key, Object value) {
        for (int ii = 0; ii < this.attributeListener.size(); ++ii) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.getServletContext(), (ServletRequest)this, key, value);
            ((ServletRequestAttributeListener)this.attributeListener.get(ii)).attributeAdded(event);
        }
    }

    private void callAttributeListenersReplacedMethod(String key, Object value) {
        for (int ii = 0; ii < this.attributeListener.size(); ++ii) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.getServletContext(), (ServletRequest)this, key, value);
            ((ServletRequestAttributeListener)this.attributeListener.get(ii)).attributeReplaced(event);
        }
    }

    private void callAttributeListenersRemovedMethod(String key, Object value) {
        for (int ii = 0; ii < this.attributeListener.size(); ++ii) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.getServletContext(), (ServletRequest)this, key, value);
            ((ServletRequestAttributeListener)this.attributeListener.get(ii)).attributeRemoved(event);
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        this.asyncContext = new AsyncContextImpl((ServletRequest)this, null);
        return this.asyncContext;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        this.asyncContext = new AsyncContextImpl(servletRequest, servletResponse);
        return this.asyncContext;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public Part getPart(String name) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        return null;
    }
}

