/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.cdi.tester.contexts.servlet;

import com.oneandone.cdi.tester.contexts.servlet.CdiUnitServlet;
import com.oneandone.cdi.tester.contexts.servlet.MockSessionContext;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

@CdiUnitServlet
public class MockHttpSessionImpl
implements HttpSession {
    private HashMap attributes;
    private String sessionId;
    private boolean isNew;
    private boolean isValid;
    private long creationTime;
    @Inject
    @CdiUnitServlet
    private ServletContext servletContext;
    private int maxInactiveInterval;
    private List attributeListener;

    public MockHttpSessionImpl() {
        this.resetAll();
    }

    public synchronized void resetAll() {
        this.attributes = new HashMap();
        this.isValid = true;
        this.creationTime = System.currentTimeMillis();
        this.sessionId = new Double(Math.random()).toString();
        this.maxInactiveInterval = -1;
        this.attributeListener = new ArrayList();
    }

    public synchronized void addAttributeListener(HttpSessionAttributeListener listener) {
        this.attributeListener.add(listener);
    }

    public synchronized void setupServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public synchronized ServletContext getServletContext() {
        return this.servletContext;
    }

    public synchronized boolean isValid() {
        return this.isValid;
    }

    public synchronized boolean isNew() {
        return this.isNew;
    }

    public synchronized void setUpIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    public synchronized long getCreationTime() {
        return this.creationTime;
    }

    public synchronized void invalidate() {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        this.isValid = false;
        HashMap clone = new HashMap(this.attributes);
        Iterator keys = clone.keySet().iterator();
        while (keys.hasNext()) {
            this.doRemoveAttribute((String)keys.next());
        }
    }

    public synchronized String getId() {
        return this.sessionId;
    }

    public synchronized Object getValue(String key) {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        return this.getAttribute(key);
    }

    public synchronized String[] getValueNames() {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        Vector attKeys = new Vector(this.attributes.keySet());
        return (String[])attKeys.toArray();
    }

    public synchronized void putValue(String key, Object value) {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        this.setAttribute(key, value);
    }

    public synchronized void removeValue(String key) {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        this.removeAttribute(key);
    }

    public synchronized void clearAttributes() {
        this.attributes.clear();
    }

    public synchronized Object getAttribute(String key) {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        return this.attributes.get(key);
    }

    public synchronized Enumeration getAttributeNames() {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        Vector attKeys = new Vector(this.attributes.keySet());
        return attKeys.elements();
    }

    public synchronized void removeAttribute(String key) {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        this.doRemoveAttribute(key);
    }

    private void doRemoveAttribute(String key) {
        Object value = this.attributes.get(key);
        this.attributes.remove(key);
        if (null != value) {
            this.callValueUnboundMethod(key, value);
            this.callAttributeListenersRemovedMethod(key, value);
        }
    }

    public synchronized void setAttribute(String key, Object value) {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        Object oldValue = this.attributes.get(key);
        if (null == value) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
        this.handleBindingListenerCalls(key, value, oldValue);
        this.handleAttributeListenerCalls(key, value, oldValue);
    }

    private synchronized void handleBindingListenerCalls(String key, Object value, Object oldValue) {
        if (oldValue != null) {
            this.callValueUnboundMethod(key, oldValue);
        }
        if (value != null) {
            this.callValueBoundMethod(key, value);
        }
    }

    private synchronized void handleAttributeListenerCalls(String key, Object value, Object oldValue) {
        if (null != oldValue) {
            if (value != null) {
                this.callAttributeListenersReplacedMethod(key, oldValue);
            } else {
                this.callAttributeListenersRemovedMethod(key, oldValue);
            }
        } else if (value != null) {
            this.callAttributeListenersAddedMethod(key, value);
        }
    }

    public synchronized long getLastAccessedTime() {
        return System.currentTimeMillis();
    }

    public synchronized void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public synchronized int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public synchronized HttpSessionContext getSessionContext() {
        return new MockSessionContext();
    }

    private synchronized void callAttributeListenersAddedMethod(String key, Object value) {
        for (int ii = 0; ii < this.attributeListener.size(); ++ii) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
            ((HttpSessionAttributeListener)this.attributeListener.get(ii)).attributeAdded(event);
        }
    }

    private synchronized void callAttributeListenersReplacedMethod(String key, Object value) {
        for (int ii = 0; ii < this.attributeListener.size(); ++ii) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
            ((HttpSessionAttributeListener)this.attributeListener.get(ii)).attributeReplaced(event);
        }
    }

    private synchronized void callAttributeListenersRemovedMethod(String key, Object value) {
        for (int ii = 0; ii < this.attributeListener.size(); ++ii) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
            ((HttpSessionAttributeListener)this.attributeListener.get(ii)).attributeRemoved(event);
        }
    }

    private synchronized void callValueBoundMethod(String key, Object value) {
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
            ((HttpSessionBindingListener)value).valueBound(event);
        }
    }

    private synchronized void callValueUnboundMethod(String key, Object value) {
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
            ((HttpSessionBindingListener)value).valueUnbound(event);
        }
    }
}

