/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.concierge;

import com.google.common.base.Preconditions;
import io.dropwizard.Application;
import io.dropwizard.setup.Environment;
import java.net.URL;
import net.oneandone.concierge.configuration.ApiGatewayConfiguration;
import net.oneandone.concierge.resource.GenericApiResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Concierge
extends Application<ApiGatewayConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(Concierge.class);
    private Environment environment;

    public void run(ApiGatewayConfiguration configuration, Environment environment) throws Exception {
        environment.jersey().register((Object)new GenericApiResource(configuration.getResolvers()));
        this.environment = environment;
    }

    public static Concierge start(URL configurationFile) throws Exception {
        Preconditions.checkNotNull((Object)configurationFile, (Object)"the configuration file URL may not be null");
        log.info("configuration file URL is {}", (Object)configurationFile);
        Concierge concierge = new Concierge();
        concierge.run(new String[]{"server", configurationFile.getFile()});
        return concierge;
    }

    public void stop() throws Exception {
        if (this.environment == null) {
            throw new IllegalStateException("environment may not be null on close");
        }
        log.debug("about to stop application");
        this.environment.getApplicationContext().getServer().stop();
    }

    private Concierge() {
    }
}

