/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.concierge.api;

import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import net.oneandone.concierge.api.Addressable;
import net.oneandone.concierge.api.Element;

public class Group
implements Addressable {
    private final String address;
    private final List<Element> elements;
    private final int total;
    private final ZonedDateTime lastModified;

    public List<Element> elements() {
        return this.elements;
    }

    public int total() {
        return this.total;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public ZonedDateTime lastModified() {
        return this.lastModified;
    }

    public static Group empty(String name) {
        return new EmptyGroup(name);
    }

    public static Group withElement(Element element) {
        Preconditions.checkNotNull((Object)element, (Object)"the element may not be null");
        return new SingleElementGroup(element);
    }

    public static Group withElements(String name, List<Element> elements, int total, ZonedDateTime zonedDateTime) {
        Preconditions.checkNotNull(elements, (Object)"the elements may not be null");
        return new MultiElementGroup(name, elements, total, zonedDateTime);
    }

    private Group(String address, List<Element> elements, int total, ZonedDateTime lastModified) {
        this.address = address;
        this.elements = elements;
        this.total = total;
        this.lastModified = lastModified;
    }

    static class MultiElementGroup
    extends Group {
        MultiElementGroup(String name, List<Element> elements, int total, ZonedDateTime lastModified) {
            super(name, elements, total, lastModified);
        }
    }

    static class SingleElementGroup
    extends Group {
        SingleElementGroup(Element element) {
            super(element.group(), Collections.singletonList(element), 1, element.lastModified());
        }
    }

    static class EmptyGroup
    extends Group {
        EmptyGroup(String address) {
            super(address, Collections.emptyList(), 0, ZonedDateTime.now());
        }
    }
}

