/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.concierge.api.filter;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.oneandone.concierge.api.filter.Filter;

public class Filters {
    private final Filter[] filters;

    public <T extends Filter> Optional<T> get(Class<T> filterClass) {
        Preconditions.checkNotNull(filterClass, (Object)"request filter class may not be null");
        for (Filter filter : this.filters) {
            if (!filter.getClass().equals(filterClass)) continue;
            return Optional.of(filterClass.cast(filter));
        }
        return Optional.empty();
    }

    public int size() {
        return this.filters.length;
    }

    private Filters(Filter[] filters) {
        this.filters = filters;
    }

    public static class Builder {
        private List<Filter> filters = new ArrayList<Filter>();

        public static Builder initialize() {
            return new Builder();
        }

        public Builder add(Filter filter) {
            Preconditions.checkNotNull((Object)filter, (Object)"tried to add filter null");
            Preconditions.checkArgument((boolean)this.filters.stream().noneMatch(addedFilter -> addedFilter.getClass().equals(filter.getClass())), (Object)("filter with class '" + filter.getClass().getSimpleName() + "' already added"));
            this.filters.add(filter);
            return this;
        }

        public Filters build() {
            return new Filters(this.filters.toArray(new Filter[this.filters.size()]));
        }

        private Builder() {
        }
    }
}

