/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.concierge.api.resolver;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import net.oneandone.concierge.api.Element;
import net.oneandone.concierge.api.Group;
import net.oneandone.concierge.api.filter.AddressFilter;
import net.oneandone.concierge.api.filter.Filters;
import net.oneandone.concierge.api.filter.PageFilter;
import net.oneandone.concierge.api.resolver.GroupResolver;

public abstract class BasicGroupResolver
implements GroupResolver {
    public abstract Optional<Element> element(Element var1, String var2);

    public abstract int total(Element var1, Filters var2);

    public abstract ZonedDateTime lastUpdate(Element var1, Filters var2);

    public abstract List<Element> elements(Element var1, int var2, int var3, Filters var4);

    @Override
    public final Group elements(Element parent, Filters filters) {
        Optional<AddressFilter> addressFilter = filters.get(AddressFilter.class);
        if (addressFilter.isPresent()) {
            Optional<Element> element = this.element(parent, addressFilter.get().getAddress());
            if (element.isPresent()) {
                return Group.withElement(element.get());
            }
            return Group.empty(this.name());
        }
        Optional<PageFilter> pageFilter = filters.get(PageFilter.class);
        int page = 0;
        int perPage = this.defaultPageSize();
        if (this.defaultPageSize() != 0 && this.maximumPageSize() != 0) {
            page = 1;
            if (pageFilter.isPresent()) {
                page = pageFilter.get().getPage();
                perPage = pageFilter.get().getPerPage().orElse(perPage);
            }
        }
        return Group.withElements(this.name(), this.elements(parent, page, perPage, filters), this.total(parent, filters), this.lastUpdate(parent, filters));
    }
}

