/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.concierge.resource;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.oneandone.concierge.api.Element;
import net.oneandone.concierge.api.Extension;
import net.oneandone.concierge.api.Group;
import net.oneandone.concierge.api.filter.Filters;
import net.oneandone.concierge.api.filter.PageFilter;
import net.oneandone.concierge.api.resolver.ExtensionResolver;
import net.oneandone.concierge.api.resolver.GroupResolver;
import net.oneandone.concierge.api.resolver.Resolver;
import net.oneandone.concierge.configuration.Resolvers;
import net.oneandone.concierge.resource.ResourceIdentifier;
import net.oneandone.concierge.resource.response.ApiResourcePaging;
import net.oneandone.concierge.resource.response.ApiResponse;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class GenericApiResource {
    private final List<ExtensionResolver> extensionResolvers;
    private final List<GroupResolver> groupResolvers;

    public GenericApiResource(Resolvers resolvers) {
        Preconditions.checkNotNull((Object)resolvers, (Object)"the resolvers may not be null");
        this.groupResolvers = resolvers.getGroupResolvers();
        this.extensionResolvers = resolvers.getExtensionResolvers();
    }

    @OPTIONS
    @Path(value="/{uri:.*}")
    public Response getOptions(@PathParam(value="uri") String uri) {
        Optional<ExtensionResolver> extensionResolver;
        ResourceIdentifier resourceIdentifier = ResourceIdentifier.parse(uri);
        String[] resolverPath = resourceIdentifier.completeHierarchy();
        Optional<GroupResolver> groupResolver = this.groupResolvers.stream().filter(r -> Arrays.equals(r.hierarchy(), resolverPath)).findAny();
        if (!groupResolver.isPresent() && !(extensionResolver = this.extensionResolvers.stream().filter(r -> Arrays.equals(r.hierarchy(), resolverPath)).findAny()).isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().header("Accept", (Object)"GET, OPTIONS").build();
    }

    @GET
    @Path(value="/{uri:.*}")
    public Response getResource(@Context HttpServletRequest request, @PathParam(value="uri") String uri) {
        HashMultimap parametersMultimap = HashMultimap.create();
        Map requestParameters = request.getParameterMap();
        for (Map.Entry entry : requestParameters.entrySet()) {
            parametersMultimap.putAll(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
        ResourceIdentifier resourceIdentifier = ResourceIdentifier.parse(uri, (Multimap<String, String>)parametersMultimap);
        ApiResponse apiResponse = this.getResponse(resourceIdentifier);
        if (apiResponse == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        JsonStructure jsonResponse = apiResponse.getObject();
        if (jsonResponse != null) {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)jsonResponse.toString());
            if (apiResponse.getPaging().isPresent()) {
                responseBuilder.header("Accept-Ranges", (Object)apiResponse.getPaging().get().getAcceptRanges());
                responseBuilder.header("Content-Range", (Object)apiResponse.getPaging().get().getContentRange());
            }
            responseBuilder.header("Last-Modified", (Object)apiResponse.getLastModified().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            return responseBuilder.build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private ApiResponse getResponse(ResourceIdentifier resourceIdentifier) {
        if (resourceIdentifier.empty()) {
            List<String> rootGroups = this.groupResolvers.stream().filter(r -> r.hierarchy().length == 1).map(Resolver::name).collect(Collectors.toList());
            return ApiResponse.create((JsonStructure)GenericApiResource.getLinks(resourceIdentifier, rootGroups, Collections.emptyList()), ZonedDateTime.now());
        }
        return this.getResponse(resourceIdentifier, null);
    }

    private ApiResponse getResponse(ResourceIdentifier resourceIdentifier, Element parent) {
        String[] resolverHierarchy = resourceIdentifier.hierarchy();
        Optional<GroupResolver> resolver = this.groupResolvers.stream().filter(r -> Arrays.equals(r.hierarchy(), resolverHierarchy)).findAny();
        if (resolver.isPresent()) {
            return this.getGroupResponse(resourceIdentifier, parent, resolver.get());
        }
        Optional<ExtensionResolver> extensionResolver = this.extensionResolvers.stream().filter(r -> Arrays.equals(r.hierarchy(), resolverHierarchy)).findAny();
        if (parent != null && extensionResolver.isPresent()) {
            Optional<Extension> extension = extensionResolver.get().resolve(parent);
            if (extension.isPresent()) {
                return ApiResponse.create((JsonStructure)extension.get().content(), extension.get().lastModified());
            }
            return null;
        }
        return null;
    }

    private ApiResponse getGroupResponse(ResourceIdentifier resourceIdentifier, Element parent, GroupResolver resolver) {
        Filters filters = resourceIdentifier.filters();
        Group group = resolver.elements(parent, filters);
        HashMultimap extensionMultimap = HashMultimap.create();
        for (String extension : resourceIdentifier.extensions()) {
            String[] extendedResolverHierarchy = resourceIdentifier.extendedHierarchy(extension);
            List extensionResolvers = this.extensionResolvers.stream().filter(e -> Arrays.equals(e.hierarchy(), extendedResolverHierarchy)).collect(Collectors.toList());
            for (ExtensionResolver extensionResolver : extensionResolvers) {
                Map<Element, Extension> resolvedExtensions = extensionResolver.resolve(group);
                for (Map.Entry<Element, Extension> elementExtensionEntry : resolvedExtensions.entrySet()) {
                    extensionMultimap.put((Object)elementExtensionEntry.getKey(), (Object)elementExtensionEntry.getValue());
                }
            }
        }
        if (resourceIdentifier.hasElementIdentifier()) {
            if (group != null && !group.elements().isEmpty()) {
                Element element = group.elements().get(0);
                return ApiResponse.create(this.getExtendedJsonStructure(resourceIdentifier, element, extensionMultimap.get((Object)element)), element.lastModified());
            }
            return null;
        }
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (Element element : group.elements()) {
            arrayBuilder.add((JsonValue)this.getExtendedJsonStructure(resourceIdentifier, element, extensionMultimap.get((Object)element)));
        }
        objectBuilder.add(resolver.name(), (JsonValue)arrayBuilder.build());
        if (resolver.defaultPageSize() > 0) {
            int lastPage;
            int perPage;
            int page;
            Optional<PageFilter> pageFilter = filters.get(PageFilter.class);
            if (pageFilter.isPresent()) {
                page = pageFilter.get().getPage();
                perPage = pageFilter.get().getPerPage().orElse(resolver.defaultPageSize());
            } else {
                page = 1;
                perPage = resolver.defaultPageSize();
            }
            ApiResourcePaging paging = ApiResourcePaging.builder().group(resourceIdentifier.groupIdentifier()).page(page).perPage(perPage).total(group.total()).build();
            JsonObjectBuilder linksBuilder = Json.createObjectBuilder();
            String linkPattern = "/" + Arrays.stream(resourceIdentifier.get()).collect(Collectors.joining("/")) + "?page=%d&perPage=%d";
            linksBuilder.add("first", String.format(linkPattern, 1, perPage));
            if (page > 1) {
                linksBuilder.add("previous", String.format(linkPattern, page - 1, perPage));
            }
            if (page < (lastPage = group.total() / perPage + 1)) {
                linksBuilder.add("next", String.format(linkPattern, page + 1, perPage));
            }
            linksBuilder.add("last", String.format(linkPattern, lastPage, perPage));
            objectBuilder.add("links", (JsonValue)linksBuilder.build());
            return ApiResponse.create((JsonStructure)objectBuilder.build(), group.lastModified(), paging);
        }
        return ApiResponse.create((JsonStructure)objectBuilder.build(), group.lastModified());
    }

    private JsonStructure getExtendedJsonStructure(ResourceIdentifier resourceIdentifier, Element parent, Collection<Extension> resolvedExtensions) {
        if (resourceIdentifier.hasNextScope()) {
            ApiResponse response = this.getResponse(resourceIdentifier.next(), parent);
            if (response != null) {
                return response.getObject();
            }
            return null;
        }
        ResourceIdentifier fullResourceIdentifier = resourceIdentifier.hasElementIdentifier() ? resourceIdentifier : resourceIdentifier.extend(parent);
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        JsonObject jsonObject = parent.content();
        for (String string : jsonObject.keySet()) {
            objectBuilder.add(string, (JsonValue)jsonObject.get((Object)string));
        }
        for (Extension extension : resolvedExtensions) {
            objectBuilder.add(extension.address(), (JsonValue)extension.content());
        }
        for (String string : fullResourceIdentifier.extensions()) {
            ApiResponse apiResponse;
            ResourceIdentifier extendedIdentifier = fullResourceIdentifier.extend(string);
            Optional<GroupResolver> resolver = this.groupResolvers.stream().filter(r -> Arrays.equals(r.hierarchy(), extendedIdentifier.completeHierarchy())).findAny();
            if (!resolver.isPresent() || (apiResponse = this.getResponse(extendedIdentifier)) == null || apiResponse.getObject() == null) continue;
            objectBuilder.add(string, (JsonValue)apiResponse.getObject());
        }
        List<String> availableSubgroups = GenericApiResource.getAvailableSubResolver(fullResourceIdentifier, this.groupResolvers);
        List<String> list = GenericApiResource.getAvailableSubResolver(fullResourceIdentifier, this.extensionResolvers);
        if (!availableSubgroups.isEmpty() || !list.isEmpty()) {
            objectBuilder.add("links", (JsonValue)GenericApiResource.getLinks(fullResourceIdentifier, availableSubgroups, list));
        }
        return objectBuilder.build();
    }

    private static List<String> getAvailableSubResolver(ResourceIdentifier resourceIdentifier, List<? extends Resolver> resolvers) {
        return resolvers.stream().filter(r -> r.hierarchy().length == resourceIdentifier.hierarchy().length + 1 && Arrays.equals(Arrays.copyOfRange(r.hierarchy(), 0, r.hierarchy().length - 1), resourceIdentifier.hierarchy())).map(r -> r.hierarchy()[r.hierarchy().length - 1]).collect(Collectors.toList());
    }

    private static JsonObject getLinks(ResourceIdentifier resourceIdentifier, List<String> availableSubgroups, List<String> availableExtensions) {
        JsonObjectBuilder linksBuilder = Json.createObjectBuilder();
        if (!availableSubgroups.isEmpty()) {
            JsonObjectBuilder groupLinkBuilder = Json.createObjectBuilder();
            for (String availableSubgroup : availableSubgroups) {
                groupLinkBuilder.add(availableSubgroup, "/" + Stream.concat(Arrays.stream(resourceIdentifier.get()), Stream.of(availableSubgroup)).collect(Collectors.joining("/")));
            }
            linksBuilder.add("groups", (JsonValue)groupLinkBuilder.build());
        }
        if (!availableExtensions.isEmpty()) {
            JsonObjectBuilder extensionLinkBuilder = Json.createObjectBuilder();
            for (String availableExtension : availableExtensions) {
                extensionLinkBuilder.add(availableExtension, "/" + Stream.concat(Arrays.stream(resourceIdentifier.get()), Stream.of(availableExtension)).collect(Collectors.joining("/")));
            }
            linksBuilder.add("extensions", (JsonValue)extensionLinkBuilder.build());
        }
        return linksBuilder.build();
    }
}

